package com.rameses.app.common.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;

class EditConsumptionModel {
        
    @Binding
    def binding;
    
    @Caller
    def caller;
    
    def reader;
    def readingdate;
    def reading;
    def prevreading;
    def capacity;
    def volume;
    def handler;
    
    def lookupReaderName;
    
    boolean allowEditPrevReading;

    @PropertyChangeListener
    def listener = [
        "reading" : { o->
            updateRate();          
        }
    ];
    
    def changePrevReading() {
        def p = [:];
        p.title = "Edit Previous Reading";
        p.fields = [
            [name:"prevreading", caption:"Previous Reading", 
                value: prevreading,
                datatype:"integer", required:true]
        ];
        p.handler = {v->
            prevreading = v.prevreading;
            updateRate();
            binding.refresh();
        }
        return Inv.lookupOpener("dynamic:form", p );
    }
    
    void updateRate() {
        if( prevreading == null ) return;
        if( reading == null ) return;
        volume = (reading > prevreading ) ? reading - prevreading : (reading + capacity) - prevreading; 
    }

    void init() {
        if(!capacity) throw new Exception("capacity is required in edit reading");
    }
    
    def doOk() {
        if(!handler) throw new Exception("Please specify handler");
        def m = [:]        
        m.reader = reader;
        m.readingdate = readingdate;
        m.reading = reading;
        m.prevreading = prevreading;
        m.capacity = capacity;
        m.volume = volume;
        handler( m );
        return "_close";
    }
    
    def doCancel() {
        return "_close";
    }
    
    def getLookupReader() {
        if(!lookupReaderName)
            throw new Exception("Please pass lookupReaderName" );
        def q = [:];
        q.query = [role:"READER"];
        return Inv.lookupOpener( lookupReaderName, q );
    }

}