package com.rameses.app.common.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;
import com.rameses.enterprise.models.*;

class DocTypeModel extends CrudFormModel {
    
    public String getConnection() {
        return caller.getConnection();
    }
    
    def getLookupSignature() {
        return Inv.lookupOpener("sys_signature:lookup", [:] );
    }
    
    def getLookupReport() {
        def h = [
            onselect: { r->
                entity.reportid = r.name;
                binding.refresh();
            }
        ]
        return Inv.lookupOpener("sys_report_def:lookup", h );
    }
    
    def getLookupTemplate() {
        def h = [
            onselect: { r->
                entity.templateid = r.name;
                binding.refresh();
            }
        ]
        return Inv.lookupOpener("sys_report_template:lookup",  h );
    }
    
}