package com.rameses.app.common.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;

class CaptureSingleBillPaymentModel  {
    
    @Binding
    def binding;
    
    @Invoker
    def invoker;

    @Controller
    def workunit;
    
    def handler;
    def amount = 0;
    def entity;
    //def selectedBillItem;
    //def billItemList = [];

    def refTypes = [
        "cashreceipt"
    ];
    
    @PropertyChangeListener
    def listener = [
        "entity.payer" : { o->
            entity.paidby = o.name;
            entity.paidbyaddress = o.address.text;
            binding.refresh("entity.paidby.*");    
        }
    ]
    
    void init() {
        entity = [:];
        entity.txnmode = "CAPTURE";
        if(amount) entity.amount = amount;
    }
    
    def previewDetails() {
        if(!entity.amount) throw new Exception("Please specify amount");
        def _list = handler.getPaymentItems(entity);
        if(!_list) throw new Exception("No items found");
        def _amt = NumberUtil.round( _list.sum{it.total} );
        def r = [items: _list, amount: _amt ];
        Modal.show("app_common:billitem_payment_preview", [entity: r ]);
    }    
    
    def previewReceipt() {
        if(!entity.amount) throw new Exception("Please specify amount");
        def rct = handler.getReceiptItems( entity );
        if(!rct.items) throw new Exception("No items found");
        if( !rct.amount ) rct.amount = rct.items.sum{it.amount};
        Modal.show("app_common:cashreceipt_preview", [entity: rct ]);
    }
    
    def postPayment() {
        if(!entity.amount) throw new Exception("Please specify amount");
        if(!MsgBox.confirm("You are about to post this payment. Proceed?")) return null;
        handler.postPayment( entity );
        return "_close";
    }
    
    
}