package com.rameses.app.common.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;

class CaptureMultiBillPaymentModel  {
    
    @Binding
    def binding;
    
    @Invoker
    def invoker;

    @Controller
    def workunit;
    
    def lookupHandler;
    def serviceName;
    def total = 0;
    def saveHandler;
    def refdate;
    
    def refTypes = [
        "cashreceipt", "postcredit"
    ];
    
    @PropertyChangeListener
    def listener = [
        "entity.payer" : { o->
            entity.paidby = o.name;
            entity.paidbyaddress = o.address.text;
            binding.refresh("entity.paidby.*");    
        }
    ]
    
    def entity;
    def selectedBill;
    def billList = [];

    def capturBillHandler;
    
    def billListModel = [
        fetchList: { o->
            return billList;   
        },
        onColumnUpdate: { item, colName ->
            total = NumberUtil.round( billList.sum{it.amount} );
            binding.refresh("total");
        }
    ] as EditorListModel;
    
    public def getPaymentService() {
        String conn = workunit.workunit.module?.getProperties().get("connection"); 
        return InvokerProxy.instance.create(serviceName, null, conn );
    }
    
    void init() {
        entity = [:];
        entity.refdate = (refdate!=null) ? refdate : new Date();
        entity.txnmode = "CAPTURE";
        lookupHandler = invoker.properties.lookuphandler;
        serviceName = invoker.properties.serviceName;
    }
    
    def addBill() {
        if(!lookupHandler) throw new Exception("Please specify a lookup handler");
        def params = [:];
        params.onselect = { o->
            billList << o;
            billListModel.reload();
            total = NumberUtil.round( billList.sum{it.amount} );
            binding.refresh("total");
        };
        params.query = entity;
        def op = null;
        try {
            op =  Inv.lookupOpener(lookupHandler, params);
        } catch(ign){;}
        if(!op) throw new Exception("lookuphandler " + lookupHandler + " not found");
        return op;
    }
    
    void removeBill() {
        if(!selectedBill) throw new Exception("Please select a bill");
        billList.remove( selectedBill );
        billListModel.reload();
        total = NumberUtil.round( billList.sum{it.amount} );
    }
    
    def viewPaymentDetails() {
        if(!selectedBill) throw new Exception("Please select a bill");
    }
    
    def viewReceipt() {
        if(!selectedBill) throw new Exception("Please select a bill");
    }
    
    def doOk() {
        if(total != entity.amount )
            throw new Exception("Amount to pay must equal total bill amount");
        //saveHandler( entity );
        entity.bills = billList; 
        if(saveHandler) {
            saveHandler( entity );
        }
        else {
            getPaymentService().postPayment( entity );
        }
        return "_close";
    }
    
    def doCancel() {
        return "_close";
    }
    
}