package com.rameses.app.common.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.enterprise.models.*;


class AppInfoEditorModel  {
    
    @Binding
    def binding;

    def fetchHandler;

    def initialInfos;
    def infos;
    def saveHandler;
    def stack = new Stack();

    boolean getShowBack() {
        return (!stack.empty());       
    }

    boolean getShowNext() {
        return (fetchHandler != null);
    }
    
    def doBack() {
        if( stack.empty() ) return 
        infos = stack.pop();
        binding.refresh();                
    }
    
    def doCancel() {
        return "_close";
    }


    def fetchInitialValue = { x->
        if( initialInfos ) {
            x.value = initialInfos.find{ it.name == x.name }?.value;
        }
    }

    void init() {
        if(!saveHandler)  throw new Exception("saveHandler is required");
        if(!infos) {
            if(!fetchHandler) throw new Exception("fetchHandler is required");
            infos = fetchHandler( [] );
        }
        infos.each {
            fetchInitialValue(it);
        }
    }

    def packAllInfos() {
        def rinfos = [];  
        rinfos.addAll( infos );  
        while(!stack.empty()) {
            rinfos.addAll( stack.pop() );   
        } 
        return rinfos;   
    }

    def doNext() {
        validateInfos();
        def allInfos = [];
        allInfos.addAll( infos );
        stack.each {
            allInfos.addAll( it );
        }
        def newInfos = fetchHandler( allInfos );
        if( newInfos ) {
            stack.push( infos );    
            infos = newInfos;
            if(newInfos.find{it.derived==true || it.derived == 1}) {
                def rinfos = packAllInfos();
                saveHandler( rinfos );
                return "_close";
            }
            else {
                infos.each { z->
                    fetchInitialValue(z);
                }
                binding.refresh();                
            }
        }   
        else {
            def rinfos = packAllInfos();
            saveHandler( rinfos );
            return "_close";
        }
    }

    def doOk() {
        validateInfos();
        saveHandler( infos );
        return "_close";    
    }    

    void validateInfos() {
        def errs = [];
        infos.each { o->
            if( o.value == null ) {
                def t = o.name;
                if( o.category ) t += "(" + o.category + ")";
                errs << t;    
            }
        }
        if(errs) 
            throw new Exception("Please provide value for the ff: \n" + errs.join("\n"));
    }


}
