package com.rameses.app.common.components;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.*;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.util.*;

class SelectWfStateComponentModel extends ComponentBean {

    String connection;
    String processName;
    boolean showTrackedItemsOnly = false;
    
    def _querySvc;
    def getQueryService() {
        if(!_querySvc) {
            _querySvc= InvokerProxy.getInstance().create("QueryService", null, connection);
        }
        return _querySvc;
    }
    
    def _items;
    public def getItems() {
        if(!_items) {
            def m = [_schemaname: "sys_wf_node"];
            def wh = "processname = :pname AND name <> 'start' ";
            if(showTrackedItemsOnly) {
                wh+= " AND tracked = 1";
            }
            m.where = [wh, [pname: processName]];
            m.orderBy = "idx";
           _items =  getQueryService().getList(m);
        }
        return _items;
    }
    
}
