package com.rameses.filemgmt.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;

public class FileItemDownloadModel  {

    @Binding 
    def binding;

    def fileitem; 
    def connection;
    def targetFile;
    
    def oncomplete;
    def ontransfer; 
    
    def fileManager = com.rameses.filemgmt.FileManager.instance;
    
    void init() { 
        if ( !fileitem )
            throw new Exception("fileitem  must be set before FileItemDownloadModel init");
        if ( !targetFile )
            throw new Exception("targetFile  must be set before FileItemDownloadModel init");

        def filelocid = fileitem.filelocid;
        
        def appEnv = ClientContext.getCurrentContext().getAppEnv(); 
        def keyName = [ connection, "filemgmt.connection" ].findAll{ it }.join("."); 
        def connFileName = appEnv.get( keyName );
        if( connFileName != null && connFileName.trim().length() > 0 ) {
            filelocid = connFileName; 
        }
        
        def fileloc = fileManager.getLocation( fileitem.connection, filelocid ); 
        if ( !fileloc ) {
            throw new Exception("'"+ fileitem.filelocid +"' file location config not found");
        }

        def names = [ fileloc.rootDir, (fileitem.objid.toString() +'.'+ fileitem.filetype)]
        def filePath = names.findAll{( it )}.join("/"); 

        def fileloctype = fileloc.type.toString().toLowerCase();
        if ( fileloctype == 'file' ) {

        } 
        else if ( fileloctype == 'ftp' ) {
            processFTP( fileloc, filePath ); 
        }
    } 
    
    void processFTP( fileloc, filePath ) {
        targetFile.getParentFile().mkdirs();
        targetFile.setExecutable(true);
        targetFile.setReadable(true);
        targetFile.setWritable(true);

        def handler = [
            onStart: { file_size-> 
                
            },
            onTransfer: { processed_count, file_size-> 
                
            },
            onError: { error-> 
                
            },
            onComplete: { 
                
            }
        ] as com.rameses.ftp.FtpStreamHandler; 

        def ftp = null;
        def fos = null; 
        try {
            fos = new java.io.FileOutputStream( targetFile ); 

            ftp = new com.rameses.ftp.FtpDownload();
            ftp.host = fileloc.url; 
            ftp.user = fileloc.user; 
            ftp.password = fileloc.password; 

            ftp.addHandler( handler ); 
            ftp.download( filePath, fos );
        }
        finally {
            try { fos.close(); }catch(Throwable t){;} 
            try { ftp.close(); }catch(Throwable t){;} 
        }

        if ( oncomplete ) {
            oncomplete(); 
        }        
    }
}