package com.rameses.treasury.common.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.* 
import com.rameses.util.BreakException

class PaymentOrderTypeModel extends CrudFormModel {
    
    def collectionTypes;
    
    public String getConnection() {
        return caller.getConnection();
    }

    void afterInit() {
        def qrySvc = InvokerProxy.instance.create("QueryService", null, null );
        def m = [_schemaname: "collectiontype"];
       	m.where = [" (connection IS NULL OR connection = :conn) AND handler NOT IN ('paymentorder') AND allowpaymentorder=1 ", [conn: getConnection() ]];
        m.select = "objid,name,title";
        m.orderBy = "name";
        collectionTypes = qrySvc.getList( m );
        collectionTypes.each{
            it.particulars = it.name +' ('+ it.title +')'; 
        }
    }
    
    void afterCreate() {
        entity.accesstype = 0;
        entity.state = 'ACTIVE';
    }
    
    public def fetchEntityData() {
        def data = super.fetchEntityData(); 
        resolveData( data );
        return data; 
    }    
    
    void resolveData( data ) {
        if ( data.collectiontype == null ) {
            data.collectiontype = [:]; 
        }

        def colltype = collectionTypes.find{( it.objid == data.collectiontype.objid )}
        if ( colltype ) {
            data.collectiontype = colltype;
        }
    }
    
    def getLookupBarcode() {
        def conn = getConnection();
        def qry = [:];
        def p = [:];
        if ( conn ) {
            qry.connection = conn; 
            p.customFilter = [" paymentorder=1 AND connection = :connection ", qry];
        }
        else {
            p.customFilter = [" paymentorder=1 AND (connection IS NULL OR connection IN ('default','etracs'))", qry] ;
        } 
        p.onselect = { o->
            entity.barcodeid = o.objid;
            binding.refresh("entity.barcodeid");
        }
        return Inv.lookupOpener("barcode_launcher:lookup", p );
    }
    
    void activate() {
        if ( entity.state.toString().toUpperCase() == 'ACTIVE' )
            throw new Exception("Record is already activated");
        
        def param = [ _schemaname: getSchemaName(), _action: 'activate' ];
        param.objid = entity.objid;
        param.state = 'ACTIVE';
        persistenceSvc.update( param ); 
        entity.state = param.state; 

        notifyDepends('status');
        refreshCallerListHandler();
    }

    void deactivate() {
        if ( entity.state.toString().toUpperCase() != 'ACTIVE' )
            throw new Exception("Record is already deactivated");
        
        def param = [ _schemaname: getSchemaName(), _action: 'deactivate' ];
        param.objid = entity.objid;
        param.state = 'INACTIVE';
        persistenceSvc.update( param ); 
        entity.state = param.state; 

        notifyDepends('status');
        refreshCallerListHandler();
    } 
    
    void refreshCallerListHandler() {
        def _list_handler = callbackListHandler;
        if ( caller instanceof PaymentOrderTypeModel ) {
            _list_handler = caller.callbackListHandler;
        }
        if ( _list_handler ) {
            _list_handler.doSearch(); 
        }
    }

    void notifyDepends( name ) {
        def _binding = this.binding;
        if ( caller instanceof PaymentOrderTypeModel ) {
            _binding = caller.binding;
        }
        if ( _binding ) {
            _binding.notifyDepends( name ); 
        }
    }     
}