package com.rameses.treasury.common.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.seti2.models.CrudListModel;

class PaymentOrderListModel extends CrudListModel  {

    def poTypeIds = [];
    
    public void initColumn( c ) { 
        if ( c.name == 'type.title') {
            c.caption = 'Type'; 
        }
        else if ( c.name == 'amount') {
            c.width = 100;
            c.maxWidth = 120;
        }
        else if ( c.name == 'expirydate') {
            c.width = 80;
            c.maxWidth = 100;
        }
        else if ( c.name == 'txndate') {
            c.width = 100;
            c.maxWidth = 140;
        }
        else if ( c.name == 'org.name') {
            c.caption = 'Org'; 
        }
    } 
    
    void afterInit() { 
        poTypeIds = [];

        def m = [_schemaname: "paymentorder_type"];
        m.where = ["accesstype = 0"];
        
        def types = queryService.getList( m ); 
        def ctx = ClientContext.getCurrentContext();
        def sec = (ctx == null ? null : ctx.getSecurityProvider()); 
        if ( sec ) {
            types.each{
                def domain = (it.domain ? it.domain.toString().trim() : '');
                def role = (it.role ? it.role.toString().trim() : '');

                if ( !domain ) domain = null; 
                if ( !role ) role = null; 
                
                boolean with_security = ( domain || role ); 
                if ( with_security ) {
                    try { 
                        if ( !role ) role = "*";
                        if ( sec.checkPermission( domain.toString(), role, null )) {
                            poTypeIds << it.objid; 
                        }
                    } 
                    catch(Throwable t) {;}
                }
                else {
                    poTypeIds << it.objid; 
                }
            }
        }
    }
    
    public void beforeQuery( param ) {
        def _schemaname = selectedNode?._schemaname; 
        if ( _schemaname ) {
            param._schemaname = _schemaname; 
        }
        
        param.types = poTypeIds; 
    }
}    