package com.rameses.entity.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.CrudLookupModel;

class EntityLookupModel extends CrudLookupModel {

    boolean allowSelectEntityType = true;
    boolean lookupSelectedItem = false;
            
    def entityTypeMatch;
                                    
    def entityTypes = ['INDIVIDUAL','JURIDICAL','MULTIPLE']; 
    def selectedType;

    void afterInit() {
        if ( entityTypeMatch ) {
            entityTypes = entityTypes.findAll{ it.toLowerCase().matches(entityTypeMatch) };
        }
    }
            
    @PropertyChangeListener
    def listener = [
        'selectedType' : { o->
            whereStatement = [ "type=:t", [t: selectedType] ];
            reload();
        }
    ];
            
    def lookupSelectedValue( def o ) {
        //load the actual record after....
        if ( lookupSelectedItem ) {
            def m = [_schemaname: 'entity' + o.type.toLowerCase() ];
            m.objid = o.objid;
            return persistenceService.read( m );
        }
        return o;
    } 

    public void initColumn( c ) { 
        if ( c.name.toString().matches('entityno|type|state')) {
            c.width = 100; 
            c.maxWidth = 140; 
        }
    } 
}