package com.rameses.entity.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.*;
import java.rmi.server.*;

class JuridicalEntityModel extends CrudFormModel {
    
    Map templateData;    
    
    public def getOrgType() {
        if( caller?.selectedNode?.name ) {
            if( caller.selectedNode.name == "all") return null;
            return caller.selectedNode.name;
        }
        else {
            return null;
        }
    }
    
    void beforeSave( mode ) { 
        entity.remove("ignore_warning"); 
    } 
    
    void afterCreate() {
        entity.objid = "JUR" + new UID();
        entity.orgtype = getOrgType();
        
        if ( templateData instanceof Map ) {
            def cloner = new com.rameses.util.DataCloner(); 
            cloner.merge( templateData, entity ); 
        } 
    }
    
    def changeName() {
        return "change-name";
    }
        
    void changeState(def invoker) {
        String s = invoker.properties.state;
        if (!MsgBox.confirm("Proceed to change state to " + s + "?")) return;
        if (!s) throw new Exception("Please specify state in invoker changeState action");
        
        def u = [objid: entity.objid, state:s, _schemaname:'entityjuridical' ];
        persistenceService.update(u);
        entity.state = s;
        reload();
    }         
}
