package com.rameses.seti2.models;

import com.rameses.common.*;
import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.common.*;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.constant.*;
import com.rameses.util.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.reports.*;
import java.rmi.server.UID;

/***
* modes
*    view-report = directly calls report. There is no back button
*    query = shows query page before the report
*    preview = called after query. There is a back page  
*/
public class FormReportModel extends ReportModel {
    
    @Caller
    def caller;
    
    @Controller
    def workunit;
    
    @Binding
    def binding;
    
    @Invoker
    def invoker;
    
    @Service("FormReportService")
    def reportService;
        
    int _captionWidth;
    
    String reportId;
    def _query = [:];
    def data;
    int status;
    Map headers;
    def task;
    def _txnid;
    
    def printmode = "preview";  //preview or printer
    def mode = "query";
    boolean aborted = false;
    
    //this determines what was first clicked for the back button to decide
    //where it will go back to. if true = query, else _close;
    boolean queryView = false;
    
    private static def scheduler = java.util.concurrent.Executors.newScheduledThreadPool(5);
    
    public Map getParameters() {
        return headers;
    }
    
    public def getQuery() {
        return _query;
    }
    
    public String getTitle() {
        String s = invoker.caption;
        if( s!=null ) {
            return s;
        }
        s = workunit.title;
        if( s != null ) return s;
        return "";
    }
    
    public Object getReportData() {
        if(data?.data) 
            return data.data;
        else
            throw new Exception("No available report data");
    }
    
    private String _connection;
    
    public String getConnection() {
        if( _connection !=null && _connection.trim().length() > 0 ) return _connection;
        if( workunit?.workunit?.module?.properties?.connection ) {
            _connection = workunit.workunit.module.properties.connection;
        }
        return _connection;
    }
    
    public void setConnection(String c) {
        _connection = c;
    }
    
    public String getReportName() {
        String s = invoker.properties.reportName;
        if( s!=null ) {
            return s;
        }
        s = workunit?.info?.workunit_properties?.reportName;
        if( s != null ) return s;
        throw new Exception("Please specify a report name");
    }
    
    public String getReportId() {
        String s = invoker.properties.reportId;
        if( s!=null ) {
            return s;
        }
        s = workunit?.info?.workunit_properties?.reportId;
        if( s != null ) return s;
        throw new Exception("Please specify a report id");
    }
    
    //dynamic txnid
    public void setTxnid( def t ) {
        _txnid = t;
    }
    
    public def getTxnid() {
        String s = invoker.properties.txnid;
        if( s==null ) {
            s = workunit?.info?.workunit_properties?.txnid;
        }
        if( s == null ) {
            return _txnid;
        }
        return ExpressionResolver.getInstance().evalString(s,caller);
    }

    public def getModel() { 
        return this; 
    }
    
    def formControls = [];
    
    public void initControl( def o ) {
        //do nothing
    }

    def getConfInfo() {
        return [reportid :getReportId(), txnid: txnid];    
    }
    
    def query() {
        queryView = true;
        mode = "query";
        //build control parameters
        def m = getConfInfo();
        formControls.clear();
        def p = reportService.getParameters(m); 
        if ( p == null ) p = [:]; 
        if ( p.parameters == null ) p.parameters = []; 
        
        for( x in p.parameters ) {
            def i = FormControlUtil.createControl( x, query, "query" );
            if ( i == null) continue;
            if ( _captionWidth != null ) {
                i.captionWidth = _captionWidth;
            } 
            initControl(i);
            formControls << i;
        } 
        return mode;
    }
    
    

    void mergeData(def newData) {
        if(newData.data==null) return;
        if(data.data==null) {
            data.data = newData.data;
        }
        else if( data.data instanceof Map ) {
            data.data.putAll( newData.data);
        }    
        else if( data.data instanceof List ) {
            data.data.addAll( newData.data);
        }
    }

    //status is intended for long running reports that needs to requery.
    boolean processReport() {
        mode = "processing";
        def m =  getConfInfo();
        m.parameters = getQuery();
        if(status) m.status = status;
        def newData = reportService.getData(m);
        //println newData;
        if(newData.status!=null) status = newData.status;
        if( status !=0 ) {
            mergeData( newData );
            return false;
        }
        else {
            mergeData(newData);
            if(newData.headers) headers = newData.headers;
            return true;
        }
    }
    
    def processor = { 
        if(aborted) {
            def m =  getConfInfo();
            aborted = false;
            def z = reportService.abort(m);
            MsgBox.alert('process aborted');
            if( queryView == true ) {
                mode = "query";
            }
            else {
                mode = "_close";
            }
        }
        else {
            boolean t = processReport();
            if( !t ) {
                mode = "processing";
                scheduler.schedule( processor, 2, java.util.concurrent.TimeUnit.SECONDS );
            } 
            else {   
                viewReport(); 
                if(printmode == 'preview') {
                    mode = "preview";
                }
                else {
                    ReportUtil.print( report, true ); 
                    mode = "query";
                }
            }
        }
        if(binding==null) {
            return mode;
        }
        else {
            binding.fireNavigation(mode);
            return mode; 
        }
    } as Runnable;
       
    void abort() {
        aborted = true;
    }
    
    def preview() { 
        mode = "preview";
        queryView = false;
        printmode = "preview";
        txnid = "QRPT"+new UID();
        data = [:];

        return processor();
    } 
    
    def sendToPrint() { 
        printmode = "printer";
        txnid = "QRPT"+new UID();
        data = [:];
        return processor();
    } 
    
    def back() { 
        mode = "query";
        return mode;
    } 
}

     