

package com.rameses.jasper.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.reports.*;
import com.rameses.seti2.models.*;
import java.text.*;

import net.sf.jasperreports.engine.*;
import net.sf.jasperreports.view.*;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import java.awt.*;


public class SysReportTemplateViewerModel {

    @Caller
    def caller;
    
    def reportTemplate;

    def reportname;
    def data;
    def params;
    
    def reportInfo;
    boolean editing;
    def reportModel;
   
    public String getConnection() {
        return caller.getConnection();
    }
    
    public def getReportTemplateService() {
        return InvokerProxy.instance.create("SysReportTemplateService", null, connection );
    }
    
    def templateSource = [

        getContent : { id->
            return getReportTemplateService().getContent( [name: id ] );
        },
        saveContent: { id,bytes,lastmod->
            getReportTemplateService().saveContent( [name:id, content:bytes, lastmodified:lastmod] ); 
        },
        
        getResources: { id->
            return getReportTemplateService().getResources( [name: id ] );
        }

    ] as SysReportTemplateSource;

    void loadReportInfo() {
        if(!reportInfo) {
            if(!reportname) throw new Exception("report name is required in SysReportTemplateViewerModel" );
            reportInfo = getReportTemplateService().getInfo([name:reportname]);
        }  
        if(!reportInfo?.filepath) throw new Exception("report filepath is required in SysReportTemplateViewerModel");
        reportTemplate = new SysReportTemplate( "reportcache/" + getConnection(), reportInfo.filepath );  
    }


    void init() {
        loadReportInfo();
    }
    
    public def getModel() {
        if(!reportModel) {
            def report = null;
            if(!params) params = [:];
            report = reportTemplate.getReport(templateSource);
            params.REPORT_CLASS_LOADER = new ExtReportTemplateClassLoader(reportTemplate, getReportTemplateService() );

            if(!data) data = [:];
            def ds = new ReportDataSource( data );
            reportModel = JasperFillManager.fillReport(report, params, ds);
        }
        return reportModel;
    }
    
    void reloadReport() {
        reportModel = null;
    }

    //edit and publish
    public void edit() {
        def win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if ( win == null ) {
            win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(); 
        }

        def jfc = new JFileChooser();
        jfc.setFileSelectionMode( JFileChooser.DIRECTORIES_ONLY ); 
        jfc.setDialogTitle("Specify workspace directory");
        jfc.setMultiSelectionEnabled( false );
        int opt = jfc.showOpenDialog( win ); 
        if ( opt != JFileChooser.APPROVE_OPTION ) {
            return; 
        } 

        def dir = jfc.getSelectedFile();
        reportTemplate = new SysReportTemplate( dir.getAbsolutePath(), reportInfo.filepath );
        reportTemplate.sync(templateSource, true );
        editing = true;
        reloadReport();
    }
    
    public void save() {
        if(!editing) throw new Exception("update must be in editing mode");
        reportTemplate.upload( templateSource, true );
        editing = false;
        loadReportInfo();
    }
}