package com.rameses.jasper.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.util.*;
import com.rameses.common.*;
import com.rameses.rcp.constant.*;
import com.rameses.osiris2.reports.*;


class SysReportHeaderModel extends CrudFormModel {
    
	def items = [];

    public String getConnection() {
        return caller.getConnection();
    }
    
    void afterOpen() {
    	buildItems();	
    }

    void buildItems() {
    	if( entity.value ) {
    		items.clear();
    		def br = new BufferedReader(new StringReader(entity.value));
    		def v = null;
    		while( (v=br.readLine())!=null ) {
    			if(v.contains("=")) {
    				def m = [:];
    				def arr = v.split("=");
    				m.key = arr[0];
    				m.value = arr[1];
    				items << m;	
    			}
    		}
    	}
    }

    def listHandler = [
    	isColumnEditable: { o,nm->
    		return (mode!='read');
    	},
    	fetchList: { o->
    		return items;
    	}
    ] as EditorListModel;

    void beforeSave(def o) {
    	def buff = new StringBuilder();
    	listHandler.getListItems().each {
    		if(it.item) {
    			def m = it.item;
    			buff.append( m.key +"="+m.value + "\n");	
    		}
    	}
    	entity.value = buff.toString();
    }

    void afterSave() {
    	buildItems();
        listHandler.reload();
    }

}