package com.rameses.jasper.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.util.*;
import com.rameses.common.*;
import com.rameses.rcp.constant.*;
import com.rameses.osiris2.reports.*;


class SysReportDefParameterModel {
    
    @Binding
    def binding;

    def reportid;
    def paramType; 
    def saveHandler;
    def entity;
    def typesList;
    def mode;

    def field;
    def fieldList = [];
    def connection;

    @PropertyChangeListener
    def listener = [
      "field" : { o->
          if(!entity) return; 
          entity.name = o.name;
          entity.caption = o.name;
          entity.type = o.type;
      }
    ];

    public def getReportSvc() {
        return InvokerProxy.instance.create("SysReportDefService", null, connection );
    }

    void initTypes() {
        if( paramType == "built-in") {
           typesList = ["text","integer","decimal","date","boolean", "lookup", "lov", "monthlist"];
        } 
        else {
           typesList = Inv.lookupOpeners('sys_report_query_filter').collect{ it.properties.name }
           typesList.sort{ it }
        }
    } 

    void initFieldList() {
       if( paramType == "built-in") {
          fieldList = getReportSvc().getBuiltinParameters( [reportid: reportid ] );
       }
       else {
          fieldList = getReportSvc().getCustomParameters( [reportid: reportid ] );
       }
    }

    void create() {
       mode = "create";
       entity = [:];
       if(paramType == 'custom') entity.custom = 1;
       else entity.prompt = 1;
       initTypes();
       initFieldList();
       if(fieldList==null) fieldList = [];
    } 

    void edit() {
       mode = "edit";
       initTypes();
       field = [name: entity.name];
    } 

    def doCancel() {
       return "_close";
    } 

    def doOk() {
       saveHandler( entity );
       return "_close";
    }  
    
    
    
}