package com.rameses.jasper.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.util.*;
import com.rameses.common.*;
import com.rameses.rcp.constant.*;
import com.rameses.osiris2.reports.*;
import net.sf.jasperreports.engine.*;

class JasperFormReportModel extends FormReportModel {
    
    @Service("JasperEmailQueueService")
    def emailSvc;
    
    @Service("SysReportTemplateService")
    def sysTemplateSvc;
    
    def entity;
    
    boolean allowSave = true;
    boolean allowPrint = true;
    
    //this is used for sys_report_template
    def reportModel;
    
    public def getReportInfo() {
        return [:];        
    }
    
    public String getDefaultEmail() {
        return "";
    }
    
    public String getHeaderName() {
        return null;
    }
    
    public String getReportPath() {
        String rPath = invoker.properties.reportPath;
        if( rPath == null ) {
            return "";
        }
        return rPath;
    }
    
    public String getReportName() {
        String rptName = invoker.properties.reportName;
        if( rptName !=null ) {
            rptName = invoker.properties.reportName;
        }
        else if(reportData.template != null) {
            rptName = reportData.template;
        }
        else {
            throw new Exception("report template not specified");
        }
        if(!rptName.contains('/')) rptName = reportPath + rptName;
        return rptName;
    }    
    
    def getQuery() {
        return [objid: entity.objid];
    }
    
    def preview(def inv) {
        if( inv.properties.allowPrint ) {
            def a = ExpressionResolver.getInstance().evalBoolean(inv.properties.allowPrint,[entity:entity, caller:caller]);
            allowPrint = a;
        }
        if(reportInfo) {
            return "preview";        
        }
        else {
            return super.preview();    
        }
    }    
    
    
    void sendEmail() {
        def m = [:];
        m.reportid = reportId;
        m.refid = query.objid;
        boolean pass = false;
        def h = { o->
            m.to = o.email;
            pass = true;
        }
        Modal.show("sys_specify_email", [email:getDefaultEmail(), handler:h] );
        if(!pass) return null;
        emailSvc.send( m );
        MsgBox.alert("message queued for sending");
    }
    
    def headerid;
    public void afterReportData( Object data ) {
        headerid = data.header;
    }
    
    public Map getParameters() {
        //get the base path of the report
        String rname = getReportName();
        String basePath = rname.substring( 0, rname.lastIndexOf("/") );
        String headPath = basePath + "/headerinfo";
        if( headerid ) {
            if(! headerid.startsWith("/")) headerid = "/" + headerid;
            headPath = basePath + headerid;
        }
        def props = new Properties();
        def is = getClass().getClassLoader().getResourceAsStream( headPath );
        if(is!=null) {
            props.load( is );
            is.close();            
        }
        return props;
    }
    
    public boolean getHasTemplate() {
        return (reportInfo!=null);
    }
    
    final def getModel() { 
        if( reportInfo ) {
            if( !reportModel ) loadSysReport();
            return reportModel;
        }
        else {
            return this;
        }
    }
    
    void loadSysReport() throws Exception  {
        def m =  getConfInfo();
        m.parameters = getQuery();
        if(status) m.status = status;
        data = reportService.getData(m);

        def conf = buildReportParameters();
        
        def filepath = reportInfo.filepath; 
        
        def appdir = SysReportLocalConf.getInstance().getAppDir();
        def cachedir = new java.io.File( appdir, "reportcache/"+ getConnection()); 

        def handler = [
            getResources: { id->
                return sysTemplateSvc.getResources( [name: id ] ); 
            },
            getContent : { id->
                return sysTemplateSvc.getContent( [name: id ] );
            }
        ] as SysReportTemplateSource;

        def st = new SysReportTemplate( cachedir.getPath(), filepath );
        def jreport = st.getReport( handler );

        def reportfile = new java.io.File( cachedir, filepath );
        def headerfile = new java.io.File( reportfile.getParentFile(), "headerinfo" ); 
        if ( headerfile.exists() ) {
            def fis = null; 
            try {
                fis = new java.io.FileInputStream( headerfile );
                def props = new Properties(); 
                props.load( fis ); 
                conf.putAll( props ); 
            } 
            catch(Throwable t){
                // do nothing 
            }
            finally {
                try { fis.close(); }catch(Throwable t){;} 
            }
        }

        String headerName = getHeaderName();
        if ( headerName != null ) {
            def hdr = sysTemplateSvc.getHeader([ name: headerName ]);
            if ( hdr ) conf.putAll( hdr );
        }
        
        def rdata = getReportData(); 
        afterReportData( rdata );

        conf.REPORT_CLASS_LOADER = new ExtReportTemplateClassLoader(st, sysTemplateSvc );

        reportModel = JasperFillManager.fillReport( jreport, conf, new ReportDataSource( rdata ) );
    }
    
    public boolean isAllowEdit() {
        return false;
    }
    
    public def shiftEdit() {
        def h = {o->
            reportInfo = o;
            reportModel = null;
        }
        def op = Inv.lookupOpener( "sys_report_template:open", [entity: reportInfo, saveHandler:h]  );
        op.target = "self";
        return op;
    }
    
}