package com.rameses.jasper.components;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.*;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.util.*;

class QueryFilterComponentModel extends ComponentBean {

    String connection;
    
    def fields;
    def controlList;
    
    def formControls = [
        getControlList: {
            return controlList;
        }
    ] as FormPanelModel;
    
    void init() {
        controlList = [];
    }
    
    def addFilter() {
        def menu = new PopupMenuOpener();
        fields.each {
            menu.add( new PopupAction(name:"addFilter", caption:it.caption, parameters:it, obj: this ) ); 
        }
        return menu;
    }
    
    void addFilter(def fld) {
        def rh = { o->
            controlList.remove( o );
            getValue().remove( o.filter );
            formControls.reload();
        }

        def filter = [:];
        filter.name = fld.name;
        getValue() << filter;

        def r = [:];
        r.caption = fld.caption;
        r.filter = filter;
        r.type = "subform";
        r.handlerObject = Inv.lookupOpener("sys_report_query_filter:"+fld.type, [field:fld, removeHandler: rh, info: r, connection:connection ] );
        controlList << r; 
        formControls.reload();
    }
    
}
