package com.rameses.jasper.components;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.*;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.util.*;

public class LookupQueryFilterModel extends AbstractQueryFilterModel {

    def operatorList = [
        [caption: "exist in list", symbol: "IN"],
        [caption: "not exist in list", symbol: "NOT IN"],
    ];
    
    def selectedItem;
    def getItems() {
        if(filter.items == null ) filter.items = [];
        return filter.items;
    }
    
    def getLovService() {
        return InvokerProxy.instance.create("LOVService", null, connection );
    }
    
    def addItem() {
        if( !field.lovname ) throw new Exception("field lovname is required");
        def r = { v->
            v.each { o->
                filter.items << [ key: o.name, value: o.name ]
            }
            binding.refresh();
        };
        def m = [
            isMultiSelect: {
                return true;
            },
            getColumns: {
                return [
                    [caption: "LOV Name", name:"name"]
                ];
            },
            fetchList: {
                return getLovService().getKeyValues( field.lovname )*.key.collect{ [name: it]  };
            }
        ] as BasicListModel;
        def op = Inv.lookupOpener("simple_list_lookup", [onselect:r, listHandler: m, title: "Lookup List of Values" ]);
        op.target = "popup";
        return op;
    }

    void removeItem() {
        if(!selectedItem) throw new Exception("Please select an item first");
        filter.items.remove(selectedItem);
        binding.refresh();
    }
    
}
