package com.rameses.jasper.components;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.*;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.util.*;

public class LookupQueryFilterModel extends AbstractQueryFilterModel {

    def operatorList = [
            [caption: "exist in list", symbol: "IN"],
            [caption: "not exist in list", symbol: "NOT IN"],
    ];
    
    def selectedItem;
    def getItems() {
        if(filter.items == null ) filter.items = [];
        return filter.items;
    }
    
    def addItem() {
        if( !field.handler ) throw new Exception("field handler is required");
        if( !field.itemkey ) throw new Exception("field itemkey is required");
        if( !field.itemvalue ) throw new Exception("field itemvalue is required");
        def r = { v->
            if(!filter.items ) filter.items = [];
            v.each { o->
                filter.items << [ key: o.get(field.itemkey), value: o.get(field.itemvalue) ]
            }
            binding.refresh();
        }
        def op = Inv.lookupOpener(field.handler, [onselect:r, multiSelect: true]);
        op.target = "popup";
        return op;
    }

    void removeItem() {
        if(!selectedItem) throw new Exception("Please select an item first");
        filter.items.remove(selectedItem);
        binding.refresh();
    }
    
}
