package com.rameses.etracs.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.*;
import com.rameses.rcp.framework.*;

class ReportListModel  {

    @Service("SysReportService")
    def reportService;
    
    String title = "Custom Reports";
    def selectedEntity;
    
    def listHandler = [ 
        getColumnList : {
            return [
                [name:"title", caption: "Title"],
                [name:"category", caption: "Category"],
            ]        
        },
        fetchList : { o->
            def r = [:];
            r.putAll( o );
            r.category = "%";
            return reportService.getListByCategory(r);
        },
        onOpenItem: {o,col->
            return openItem(o);
        }
    ] as PageListModel;    
    
    def viewReport() {
        if(!selectedEntity) throw new Exception("Please select report");
        return openItem(selectedEntity);
    }
    
    def openItem(v) {
        def p = [:];
        p.reportDef = v;
        p.title = v.title;
        return Inv.lookupOpener("sys_report_form", p);
    }
    
} 
