package com.rameses.gov.etracs.market.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;


class MarketSubAccountModel extends CrudFormModel {
    
    public String getBilltype() {
        return invoker.properties.billtype;
    }
    
    public String getAcctid() {
        return entity.acctid;
    }
    
    public def getCurrentBill() {
        def m = [_schemaname: "vw_market_" + getBilltype().toLowerCase() + "_bill"];
        m.findBy = [subacctid: entity.objid ];
        m.orderBy = "year DESC, month DESC";
        return queryService.findFirst( m );
    }
    
     void addToGroup() {
        def h = { o->
            def m = [_schemaname: "market_billgroup_unit"];
            m.billtype = getBilltype().toUpperCase();
            m.billgroupid = o.objid;
            m.unit = [objid: entity.unitid];
            m.state = "ACTIVE";
            persistenceService.create( m );
            entity.billgroupid = o.objid;
            binding.refresh();
        }
        Modal.show("market_billgroup:" + getBilltype().toLowerCase() +  ":lookup", [onselect:h])
    } 
    
}