package com.rameses.gov.etracs.market.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;

class MarketRentalUnitModel extends CrudFormModel {
    
    def unitTypes; 
    def rateTypes = ["MONTH", "DAY"]; 
    
    @PropertyChangeListener
    def listener = [
        "entity.orgunit" : { o->
            entity.center = o.center; 
            if ( entity.center == null ) {
                entity.center = [:];
            }
            if ( !entity.center?.objid ) {
                entity.center.objid = o.centerid; 
            } 
        }
    ];

    //this is needed for refreshing
    public String getEntitySchemaName() {
        return "market_rental_unit";
    } 

    public String getSchemaName() {
        return "vw_market_rental_unit";
    } 

    void loadUnitTypes() {
        def m = [_schemaname: "market_rental_unit_type"];
        m.where = ["1=1"];    
        unitTypes = queryService.getList( m )*.objid;
    }

    void afterCreate() {
        entity.state = "DRAFT";
        loadUnitTypes();
    }

    void afterOpen() {
        loadUnitTypes();
    }
    
    
    def updateRate() {
    	def h = { o->
            def m = [_schemaname:"market_rental_rate"];   
            m.unitid = entity.objid;
            m.putAll( o );
            persistenceService.create(m);
            reloadEntity();		
    	}
    	return Inv.lookupOpener( "market_rental_rate:create", [handler:h ]);
    }

    void activate() {
        if( entity.billgroupid == null  ) 
            throw new Exception("Please specify a billgroup");
        def m = [_schemaname:entitySchemaName];    
        m.objid = entity.objid;
        m.state = "ACTIVE";
        persistenceService.update( m );
        entity.state = m.state;
    }

    void deactivate() {
        def m = [_schemaname:entitySchemaName];    
        m.objid = entity.objid;
        m.state = "INACTIVE";
        persistenceService.update( m );
        entity.state = m.state;
    }
    
    void addToGroup() {
        def h = { o->
            def m = [_schemaname: "market_billgroup_unit"];
            m.billtype = "RENTAL";
            m.billgroupid = o.objid;
            m.unit = [objid: entity.objid];
            m.state = "ACTIVE";
            persistenceService.create( m );
            entity.billgroupid = o.objid;
            binding.refresh();
        }
        Modal.show("market_billgroup:rental:lookup", [onselect:h])
    }  
    
    void removeFromGroup() {
        if(!MsgBox.confirm("This will remove this unit from the billgroup. Proceed?")) return;
        def m = [_schemaname: "market_billgroup_unit"];
        m.findBy = [ billgroupid:entity.billgroupid, unitid: entity.objid  ]
        persistenceService.removeEntity( m );
        entity.billgroupid = null;
    }   
    
    def join( list, delim ) {
        if ( !list ) return "";
        if ( delim == null ) delim = " "; 
        return list.findAll{( it )}.join( delim ); 
    }
}