package com.rameses.gov.etracs.market.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;

class MarketRentalRateModel {
    
    @Service("PersistenceService")
    def persistenceSvc;
    def mode;
    
    def entity;
    def handler;
    def rateTypes = ["MONTH", "DAY"]; 

    void init() {
        mode = "create";
        entity = [:];
    }

    void open() {
        mode = "update";
        entity._schemaname = "market_rental_rate";
        entity = persistenceSvc.read( entity );
    }
    
    def doOk() {
        if( mode == "create" ) {
            if(!MsgBox.confirm("This will update the existing rate. Proceed?")) return;
            handler( entity );
            return "_close";
        } 
        else {
            def m = [_schemaname: "market_rental_rate"];
            m.objid = entity.objid;
            m.rate = entity.rate;
            m.ratetype = entity.ratetype;
            persistenceSvc.update( m );
            return "_close";
        }
    }
    
    def doCancel() {
        return "_close";
    }
}

