
package com.rameses.gov.etracs.market.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.client.notification.socketio.*;
import com.rameses.osiris2.client.*;

class MarketRentalBillListModel extends CrudListModel  {

    String notificationid = "market_rental_bill_list";
    def marketCenterList;
    def billgroupList;
    
    def centerid;
    def billgroupid;
    
    @PropertyChangeListener
    def listener = [
        "centerid|billgroupid" : { o->
            reload();
        }
    ];
    
    def atomicBoolean = new java.util.concurrent.atomic.AtomicBoolean(false);
    def notifyHandler = [
        onMessage: { msg ->
            if ( atomicBoolean.compareAndSet(false, true)) {
                reload();
                binding.refresh();
                atomicBoolean.set(false);
            }
        }
    ] as DefaultNotificationHandler;
    
    void init() {
        super.init();
        TaskNotificationClient.getInstance().register(notificationid, notifyHandler );
        
        //initial value is all
        def m = [_schemaname:"market_center", where: ["1=1", [:]]];
        marketCenterList = queryService.getList( m ); 

        m = [_schemaname: "market_billgroup"];
        m.where = " billtype = 'RENTAL' ";
        billgroupList = queryService.getList( m );
    }
    
    public void initColumn( c ) { 
        if ( c.name == 'billno') {
            c.width = 140; 
            c.maxWidth = 150; 
        }
        else if ( c.name.toString().matches('billdate|duedate|expirydate|validitydate')) {
            c.width = 80; 
            c.maxWidth = 100; 
            c.type = 'date';
            c.dateFormat = 'yyyy-MM-dd'; 
        }
        else if ( c.name == 'acctno') {
            c.width = 140; 
            c.maxWidth = 150; 
        }
        else if ( c.name == 'year') {
            c.width = 65; 
            c.maxWidth = 80; 
            c.type = 'integer';
        }
        else if ( c.name == 'monthname') {
            c.width = 80; 
            c.maxWidth = 80; 
        }
        else if ( c.name == 'balance') {
            c.width = 100; 
            c.maxWidth = 120; 
            c.type = 'decimal';
        }
    } 
    
    public def getCustomFilter() {
        def str = "centerid = :centerid"
        def parms = [centerid:centerid];
        if(billgroupid) {
            str += " AND billgroupid = :billgroupid";
            parms.billgroupid = billgroupid;
        }
        return [str, parms];
    }
    
    //notification
    @Close
    void onClose() {
        TaskNotificationClient.getInstance().unregister(notifyHandler );
    }
    
    def print() {
        MsgBox.alert("call print! ");
        MsgBox.alert("selected node is " + selectedNode );
    }
    
}