package com.rameses.gov.etracs.market.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;
import com.rameses.enterprise.models.*;
import com.rameses.menu.models.*;

class MarketFXMenuCategoryModel  extends FXMenuCategoryModel {

    @Service("MarketMenuService")
    def menuSvc;
    
    @Service("SysReportService")
    def reportSvc;
    
    def buildInvokers = { list, subitems, invokers, category ->
        int i = 100;
        list.each {
            try {
                if(!it.handler) return;
                def title = it.handler;
                def id = title + "/" + it.objid;
                def notid = (title + ":" + it.objid.toLowerCase()).trim();
                def subitem = [ id: id, caption: it.title, index: (i++), notificationid: notid, event: title ];
                subitems << subitem;
                def sinv = title + ":list";
                def stitle = it.title;
                if( category ) stitle = it.title + " (" + category + ")";
                def op = Inv.lookupOpener(sinv, [typeid: it.objid, 'title': stitle ]);
                op.domain = "MARKET";
                op.target = 'window';
                op.id = sinv;
                invokers.put( id, op );
                subitem.modulename = "market";
                subitem.domain = op.domain;
                subitem.connection = "market";      
            }
            catch(e) {
                //println e.message;
            }
        }
    }
    
    def addReportInvoker = { o, subitems, invokers->
        def id = "sys_report:market:"+o.name;
        def subitem = [id:id, caption:o.title, index:o.sortindex];
        subitems << subitem;
        
        def invokerMap = [:];
        invokerMap.params = [
            reportDef:  o,
            title: o.title,
            connection: "market",
        ];
        invokerMap.handler = { p->
            def op = Inv.lookupOpener("sys_report_form", p);
            op.domain = "MARKET";
            op.target = 'window';
            op.id = id;
            return op;
        }
        invokers.put( id, invokerMap );
    }
    
    def taskitemMenu;
    
    void loadDynamicItems( String _id, def subitems, def invokers ) {
        if( _id == "billing" ) {
                       
        }
        else if( _id == "reports" ) {
            def list = reportSvc.getListByCategory([ category: "market_reports" ] );
            list.each {
                addReportInvoker( it, subitems, invokers );    
            }
        }
    }
    
}