
package com.rameses.gov.etracs.market.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;

class MarketCompromiseModel extends CrudFormModel {
    
        @Service("MarketCompromiseService")
        def compSvc;
        
    
        def pagemode = "view";
        
        @PropertyChangeListener
        def listener = [
            "entity.bill" : { o->
                entity.account = [objid:o.acctid, acctname:o.acctname, acctno:o.acctno];
                entity.bill = o;
                entity.unitno = o.unitno;
            }
        ]
    
        def create() {
            pagemode = "info";
            return super.create();
        }
    
        def open() {
            pagemode = "view";
            return super.open();
        }
    
        void fetchBill() {
            def r = [billid: entity.bill.objid, tobilldate: entity.tobilldate];
            def bill = compSvc.getBillAmount( r );
            
            if(bill.amount < 0 )
                throw new Exception("Bill balance must be greater than 0");
            entity.amount = bill.amount;
            pagemode = "view";
        }
    
        void doBack() {
            pagemode = "info";
        }
    
        void approve() {
            def r = compSvc.approve( [objid: entity.objid] );
            entity.putAll( r );
        }

}   