
package com.rameses.gov.etracs.market.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;
import com.rameses.client.notification.socketio.*;

class MarketChangeAppModel extends WorkflowTaskModel  {

    @Service("LOVService")
    def lovService;
    
    @Service("MarketChangeAppService")
    def changeAppSvc;

    def acctno;
    def appTypes;
    def paymentModes;
    
    @PropertyChangeListener
    def listener = [
        "entity.newacctinfo.owner" : { o->
            if(!entity.newacctinfo.acctname  ) {
                entity.newacctinfo.acctname = o.name;
                binding.refresh("entity.newacctinfo.acctname");
            }
        }
    ];
    
    void afterInit() {
        appTypes =  lovService.getKeyValues("MARKET_CHANGEAPP_TYPE")*.key;
        paymentModes =  lovService.getKeyValues("MARKET_PAYMENT_MODES")*.key;
    }
    
    public def getAvailableUnitLookup() {
        def p = [:];
        p.query = [centerid: entity.oldacctinfo.unit.centerid ];
        return Inv.lookupOpener( "market_rental_unit:available:lookup", p);
    }
    
    void afterCreate() {
        entity.apptype = invoker.properties.apptype;
    }
    
    def loadAccount() {
        def m = changeAppSvc.retrieveAccount([acctno: acctno, apptype: entity.apptype ]);
        entity.account = m.account;
        entity.newacctinfo = m.newacctinfo;
        entity.oldacctinfo = m.oldacctinfo;
        return "default";
    }



}