
package com.rameses.gov.etracs.market.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;

class MarketCenterModel extends CrudFormModel  {

    def types;
    boolean showIndex = false;

    @PropertyChangeListener
    def listener = [
        "showIndex" : { o->
            treeListModel.update();
//            treeListModel.reloadTree();
        }
    ]

    void afterCreate() {
        if(!entity.address) entity.address = [:];
    }
    
    void afterOpen() {
        if(!entity.address) entity.address = [:];
    }
    
    void afterSave() {
        if(mode=="create") treeListModel.reloadTree();        
    }
    
    void reindex() {
        def m = [_schemaname:schemaName];
        m.objid = entity.objid;
        m._action = "reindex";
        persistenceService.doAction( m );
        MsgBox.alert("reindex successful");
    }
    
    def formatNode( def o ) {
        def cap =  o.name ; 
        if( showIndex == true ) cap += " ["+o.leftindex+","+o.rightindex+"]" ;
        return  [id: o.objid, name: o.name, caption:cap, item: o, fullpath: o.fullpath, 
            leftindex:o.leftindex,rightindex:o.rightindex,centerid: o.centerid ];
    }

    def  treeListModel = [
        isRootVisible: {
            return false;
        },
        isAllowOpenOnSingleClick: {
            return false; 
        },
        fetchItem: { node-> 
            // update the data of the selected node 
            if ( !node?.item ) return null; 

            def m = [_schemaname: "market_orgunit"];
            m.where = ["objid = :objid ", [objid: node.item.id]]; 
            def list = queryService.getList( m ); 
            if ( !list ) return null; 

            def fo = list.first(); 
            return formatNode( fo ); 
        },
        fetchList: { o->
            def nodes = [];
            boolean auto_expand = false; 
            def m = [_schemaname: "market_orgunit"];
            if ( o.id == 'root' ) {
                m.where = ["objid = :objid ", [objid:entity.objid]]; 
                auto_expand = true; 
            }
            else {
                m.where = ["parentid = :parentid ", [parentid:o.id]];    
            }
            m.orderBy = "leftindex";
            queryService.getList(m).each {
                def nn = formatNode( it );
                nn._expand = auto_expand; 
                nodes << nn;
            }
            return nodes;
        },
    
        getContextMenu: { node->
            def menu = new PopupMenuOpener();
            menu.add( new PopupAction(name:"refreshNode", caption:"Refresh", obj: this ) );
            
            menu.add( new PopupAction(name:"addGroup", caption:"Add Group", parameters:node.item, obj:this ));
            if( node.item?.item?.parentid ) {
                menu.add( new PopupAction(name:"editNode", caption:"Edit", parameters:node.item, obj: this ) ); 
                menu.add( new PopupAction(name:"removeNode", caption:"Remove", parameters:node.item, obj: this ) );
            }                
            menu.add( new PopupAction(name:"showUnits", caption:"Show Units", parameters:node.item, obj: this ) );
            return menu;
        },
        
        onUpdate: { node-> 
            def o = node?.item;
            if ( !o ) return;
            
            def caption =  o.name; 
            if ( showIndex ) { 
                caption += " ["+ o.leftindex +","+ o.rightindex +"]";
            }
            o.caption = caption;
        }
    ] as TreeNodeModel;

    def editNode(def o) {
        def p = [:];
        p.entity = [objid: o.id ];
        p.onSaveHandler = { v->
            def node = treeListModel.selectedNode; 
            if (node) node.refresh(); 
        }
        def op=  Inv.lookupOpener( "market_orgunit:open", p );
        op.target = "popup";
        return op;
    }
    
    void removeNode(def o) {
        if(!MsgBox.confirm("You are about to remove this node and its contents. Continue?")) return;
        def p = [_schemaname:"market_orgunit"];
        p.objid = o.id;
        persistenceService.removeEntity( p );

        def node = treeListModel.selectedNode; 
        if (node) node.remove(); 
    }
    
    def refreshNode() {
        def node = treeListModel.selectedNode; 
        if (node) node.refresh(); 
    }
    
    def addGroup( def o) {
        def m = [:];
        m.parentOrg = [objid: o.id, name: o.name];
        m.centerid = entity.objid;
        m.onSaveHandler = { v->
            def node = treeListModel.selectedNode; 
            if (node) node.refresh(); 
        }
        def op = Inv.lookupOpener("market_orgunit:create", m );
        op.target = "popup";
        return op;  
    }
    
    def showUnits( o ) {
        def m = [:];
        m.query = [orgunitid: o.id, title: o.fullpath,rightindex:o.rightindex, leftindex:o.leftindex, centerid: o.centerid];
        def op = Inv.lookupOpener("market_rental_unit:by_orgunit:list", m );
        op.target = "self";
        return op; 
    }
    
    def reloadEntity() {
        def ob = super.reloadEntity();
        treeListModel.reloadTree();
        return ob;
    }
    
    void lookupLogo() {
        def p = [:];
        p.onselect = { z->
            entity.logoid = z.objid;
            binding.refresh();
        }
        Modal.show( "market_sys_image:lookup", p ); 
    }

    void removeLogo() {
        entity.logoid = null;
    }

    def viewLogo() {
        return Inv.lookupOpener("sys_image:open", [entity: [objid: entity.logoid]]);
    }

}

