package com.rameses.gov.etracs.market.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;
import com.rameses.app.common.models.*;

class MarketBillModel extends AbstractMonthlyBillModel {
    
    @Service("MarketBillingService")
    def billService;

    @Service("MarketPaymentService")
    def pmtSvc;

    public String getAcctid() {
        return entity.acctid;
    }
    
    public String getBillType() {
        return invoker.properties.billtype?.toUpperCase();     
    }
    
    def create() {
        if(!caller.currentBill) {
            entity = [:];
            entity.acctid = caller.acctid
            entity.billtype = getBillType();
            return "initial";
        }
        else {
            throw new Exception("Cannot create bill from this action. Open instead the latest bill and click Generate Next Bill" );
            //entity = caller.currentBill;
            //return generateNextBill(false);
        }
    }
    
    def generateNextBill() {
        return generateNextBill(true)
    }
    
    def generateNextBill(boolean _reload) {
        def ent = [:];
        ent.acctid = getAcctid();
        ent.billtype = getBillType();
        ent.year = entity.year;
        ent.month = entity.month + 1;
        if(ent.month>12) {
            ent.month = 1;
            ent.year = ent.year + 1;
        }
        entity = billService.create(ent);
        if(_reload) reloadAll();
        return "default";
    }

    public def saveInitialBill() {
        if(!MsgBox.confirm("You are about to create the initial bill. Proceed?")) return;
        entity = billService.create( entity );
        open(); 
        return "default";       
    }

    public void afterReload() {
        if(billItemHandler.reload) billItemHandler.reload(); 
        if(pmtHandler.reload) pmtHandler.reload();   
        binding.refresh();
    }

    void reloadSource() {
        try {
            caller.reloadEntity();    
        }
        catch(ex){;}    
    }

    void reloadAll() {
        reloadEntity();
        if(billItemHandler.reload) billItemHandler.reload(); 
        if(pmtHandler.reload) pmtHandler.reload();  
        binding.refresh();
        reloadSource();
    }

    public void afterCancel() {
        reloadSource();
    }

    def billItems;
    def billItemHandler = [
        addItems: { o->
            o.billid = entity.objid;  
            billService.addBillItem( o );
            reloadAll();
        },
        updateItem : { o->
                    
        },
        clearItems: {
            getBillService().clearBillItems( [billid: entity.objid ] );
            reloadAll();
        },
        removeItems: { o->
            def r = [items: o, billid: entity.objid ];
            getBillService().removeBillItems( r );
            reloadAll();
        },
        fetchList: { o->
            o.billid = entity.objid;
            billItems = getBillService().getBillItems( o );
            return billItems;
        },
        lookupAccount: {
            return Inv.lookupOpener("market_itemaccount:lookup", [:] );
        },
        options : [
            showYear: true,
            showMonth: true
        ],
        executeRules : {
            def txndate = null;
            def h = { o->
                txndate = o;
            }
            Modal.show( "date:prompt", [handler: h] );
            if( !txndate ) throw new BreakException();
            getBillService().assess( [billid: entity.objid, txndate: txndate ] );
            reloadAll();            
            return null;   
        }
    ];

    def pmtHandler = [
        removeItem: { o->
            pmtSvc.voidPayment( o );
            reloadAll();
        },
        fetchItems: { o->
            return pmtSvc.getList( [billid: entity.objid ] );           
        },
        getPaymentItems: { o->
            if(!o.txndate) o.txndate = entity.billdate;
            def res = pmtSvc.getPaymentInfo( [billid: entity.objid, amtpaid: o.amount, txndate: o.refdate ] );
            return res.billitems;
        },
        getReceiptItems: { o->
            if(!o.txndate) o.txndate = entity.billdate;
            def res = pmtSvc.getPaymentInfo( [billid: entity.objid, amtpaid: o.amount, txndate: o.refdate ] );
            return [items: res.items]; 
        },
        postPayment: { o->
            def res = pmtSvc.getPaymentInfo( [billid: entity.objid, amtpaid: o.amount, txndate: o.refdate ] );
            o.postingitems = res.postingitems;
            o.items = res.items; 
            pmtSvc.postPayment( o );
            reloadAll();
        }
    ];

    def join( list, delim ) {
        if ( !list ) return "";
        if ( delim == null ) delim = " "; 
        return list.findAll{( it )}.join( delim ); 
    }    
}