package com.rameses.gov.etracs.market.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;

class MarketBillGroupModel extends CrudFormModel {
    
    def rentalUnitList;
    def scheduleList;
    
    void afterCreate() {
        entity.objid = "";
        entity.state = "ACTIVE";
        entity.billtype = caller.getBilltype();
        entity.autopost = 0;
    }

    def addSchedule() {
        def h = { o->
            scheduleList.reload();
        }
        return Inv.lookupOpener("market_billschedule:select", [onselect:h, billtype:entity.billtype, billgroupid:entity.objid] );
    }
    
    void doAction(action,params) {
        def m = [:];
        if(params) m.putAll(params);
        m._schemaname = schemaName;
        m._action = action;
        m.objid = entity.objid;
        m.billtype = entity.billtype;
        persistenceService.doAction( m );
    }

    def addUnits() {
        def p = [:];
        p.onselect = { v->
            def m = [_schemaname: "market_billgroup"];
            m.objid = entity.objid;
            m.billtype = entity.billtype;
            m.units = v;
            m._action = "addUnits";
            persistenceService.doAction( m );
            rentalUnitList?.reload();
        }
        p.multiSelect = true;
        def op =  Inv.lookupOpener( "market_billgroup_unit_" + entity.billtype.toLowerCase() + ":available:lookup", p );
        return op;
    }
    
    def units_EventHook = [
        afterFetchList: { list-> 
            list.each{
                if ( it.account instanceof Map ) {
                    it.acct_description = it.account.acctno +" - "+ it.account.acctname;
                }
            }
        }
    ]; 
}