
package com.rameses.gov.etracs.market.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;
import com.rameses.client.notification.socketio.*;
import com.rameses.seti2.models.*;
import com.rameses.jasper.models.*;

class MarketBatchRentalRateModel extends CrudFormModel  {

    def unitListHandler;

    def rateTypes = [ "MONTH", "DAY" ];
    
    void afterCreate() {
        entity.state = "DRAFT";
        entity.fixed = 0;
        entity.includeunits = 0;
        entity.frequency = 0;
    }     
    
    public boolean isEditAllowed() {
        if( entity.state == 'DRAFT' ) {
            return super.isEditAllowed();
        }
        else {
            return false;
        }
    }
    
    def deploy() {
        if(!MsgBox.confirm("You are about to deploy this batch. Proceed?")) return;
        def m = [_schemaname: "market_batch_rental_rate"];
        m.objid = entity.objid;
        m._action = "deploy";
        persistenceService.doAction( m );
        return "_close";
    }
    
    def addOrgunit() {
        if(!entity.center?.objid) throw new Exception("Please select a market center first");
        def p = [:];
        p.query = [centerid: entity.center.objid];
        p.onselect = { v->
            entity.orgunit = v.fullpath;
            binding.refresh("entity.orgunit");
        }
        return Inv.lookupOpener( "market_orgunit:bycenter:lookup", p )
    }
    
    def addUnits() {
        if(!entity.center?.objid) throw new Exception("Please select a market center first");
        def filter = [];
        def parms = [:];
        if( entity.orgunit ) {
            filter << "orgunit.fullpath LIKE :fullpath";
            parms.put( "fullpath", entity.orgunit + "%");
        }
        else {
           filter << "centerid LIKE :centerid"; 
           parms.put("centerid" , entity.center.objid);
        }
        def p = [:];
        p.customFilter = [filter.join(" AND "), parms ];
        p.onselect = { v->
            entity.units = v*.code.join(",");
            binding.refresh("entity.units");
        };
        p.multiSelect = true;
        return  Inv.lookupOpener( "market_rental_unit:lookup", p )
    }
    
}