
package com.rameses.gov.etracs.market.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;

class MarketAddBillGroupUnitModel {

    @Service("QueryService")
    def querySvc;
    
    def handler;
    def center;
    def orgunit;
    def unit;
    
    def centerList;
    def _orgUnitList;
    
    @PropertyChangeListener
    def listener = [
        "center" : { o->
            _orgUnitList = null;
        }
    ];
    
    public def getOrgunitList() {
        if(!center) return [];
        if(!_orgUnitList) {
            def m = [_schemaname: "market_orgunit"];
            m.findBy = [centerid:center.objid ];
            m.orderBy = "leftindex ASC";
            _orgUnitList = querySvc.getList(m);
        }
        return _orgUnitList;
    }
    
    void init() {
        def m = [_schemaname: "market_center"];
        m.where = ["1=1"];
        centerList = querySvc.getList(m);
    }
    
    def doOk() {
        def m = [:];
        if(center) m.centerid = center.objid;
        if(orgunit) m.orgunitid = orgunit.objid;
        if(unit) m.unit = unit;
        if(!m) throw new Exception("Please specify at least one filter");
        handler( m );
        return "_close";
    }
    
    def doCancel() {
        return "_close";
    }

}