package com.rameses.gov.etracs.market.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;


class MarketAccountModel extends WorkflowTaskModel {
    
    public String getSchemaName() {
        return "vw_market_account";
    }
    
    public String getEntitySchemaName() {
        return "market_account";
    }
    
    public String getAcctid() {
        return entity.objid;
    }

    public def getCurrentBill() {
        def m = [_schemaname: "vw_market_rental_bill"];
        m.findBy = [acctid: entity.objid ];
        m.orderBy = "year DESC, month DESC"; 
        def r = queryService.findFirst( m );
        return r;
    }
    
    public void approve() {
        if(!MsgBox.confirm("You are about to approve this record. Proceed?")) return;
        def u = [:];
        u._schemaname = schemaName;
        u.objid = entity.objid;
        u.state = "ACTIVE";
        persistenceService.update( u );
        entity.state = u.state;
    }
    
    public def viewUnit() {
        if(!entity.unitid ) throw new Exception("There is no assigned unit for this account");
        def op = Inv.lookupOpener( "market_rental_unit:open", [entity: [objid: entity.unitid ]] );
        op.target = "popup";
        return op;
    }

    def join( list, delim ) {
        if ( !list ) return "";
        if ( delim == null ) delim = " "; 
        return list.findAll{( it )}.join( delim ); 
    }    
}