
package com.rameses.gov.etracs.market.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;

class MarketAccountCreateModel extends CrudFormModel  {

    @Service("LOVService")
    def lovService;
    
    def paymentModes;
    
    void afterInit() {
        paymentModes =  lovService.getKeyValues("MARKET_PAYMENT_MODES")*.key;
    }
    
    public boolean isEditAllowed() {
        return false;
    }
    
    //this is needed for refreshing
    public String getEntitySchemaName() {
        return "market_account";
    } 

    public String getSchemaName() {
        return "vw_market_account";
    } 
    
    @PropertyChangeListener
    def listener = [
        "entity.center": { o->
            entity.centerid = o?.objid;
            entity.unit = null;
        },
        "entity.unit" : { o->
            entity.unitid = entity.unitno = null; 
            entity.rate = entity.ratetype = null; 
            entity.orgunit = null; 
            
            if ( o?.objid ) {
                entity.unitid = o.objid;
                entity.unitno = o.code; 
                entity.rate = o.currentrate?.rate;
                entity.ratetype = o.currentrate?.ratetype;
                entity.orgunit = o.orgunit;
            }
        },
        "entity.owner" : { o->
            if ( !entity.acctname ) {
                entity.acctname = o.name;
                binding.refresh("entity.acctname");
            }
        }
    ];
    
    void afterCreate() {
        entity.state = "ACTIVE";
        entity.txnmode = "CAPTURE";  
        entity.paymentmode = "MONTHLY";
    }
    
    public def getAvailableUnitLookup() {
        if ( !entity.centerid ) {
            MsgBox.alert("Please select a Market Center first"); 
            throw new BreakException();
        }
        
        def p = [:];
        p.query = [ centerid: entity.centerid ];
        return Inv.lookupOpener( "market_rental_unit:available:lookup", p);
    }
    
    
    def join( list, delim ) {
        if ( !list ) return "";
        if ( delim == null ) delim = " "; 
        return list.findAll{( it )}.join( delim ); 
    }
}