package com.rameses.gov.etracs.obo.components;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.*;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.util.*;

class MarketCenterLookupComponentModel extends ComponentBean {

    @Service(value="QueryService", connection="market")
    def querySvc;
    
    def marketCenterList;
    
    @PropertyChangeListener
    def listener = [
        "value" : { o->
            if(o==null) setValue("%");
            getCaller().reload();
        }
    ];
    
    void init() {
        //initial value is all
        setValue( "%");
        def m = [_schemaname:"market_center"];
        m._limit = 1000;
        marketCenterList = querySvc.getList(m);
    }
    
}
