package com.rameses.gov.etracs.market.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.util.*;
import com.rameses.treasury.common.models.*;

public class MarketCashReceiptModel extends CommonCashReceiptModel {
    
    @Service("MarketCashReceiptService")
    def cashRctSvc;

    def selectedBill;
    def bills = [];


    boolean needs_reload;
    def billitems = [];

    def billListModel = [
        fetchList: {
            return bills;        
        },
        onColumnUpdate: { colName, o ->
            updateBalance();
        }
    ] as EditorListModel;

    
    void updateBalance() {
        needs_reload = true;
        if(!bills) 
            entity.amount = 0;
        else
            entity.amount = NumberUtil.round( bills.sum{ it.amount } );
        binding.refresh("entity.amount");             
    }

    def addBill() {
        def sh = { bill->
            def bb = [:];
            bb.billid = bill.objid;
            bb.billno = bill.billno;
            bb.billtype = bill.billtype;
            bb.unitno = bill.unitno;
            bb.billtype = bill.billtype;
            bb.acctname = bill.acctname;
            bb.acctno = bill.acctno;
            if(bill.balance < 0 ) 
                bb.amount = 0;
            else
                bb.amount = bill.balance;    
            bills << bb;
            updateBalance();
            billListModel.reload();  
        } 
        Modal.show("market_cashreceipt:addbill", [onselect:sh, receipt: entity] );
    }

    void removeBill() {
        if(!selectedBill) throw new Exception("Please select bill to remove");
        bills.remove(selectedBill);
        updateBalance();
    }

    void loadBill() {
        if(!bills) throw new Exception("Please select at least one bill");
        if( !needs_reload ) return;
        def r = cashRctSvc.getPaymentInfo( [bills: bills, txndate: entity.receiptdate ] );
        entity.items = r.items;
        entity.postingitems = r.postingitems;
        billitems = r.billitems;
        needs_reload = false;
    }

    def viewPaymentDetails() {
       loadBill();
       def rct = [:];
       rct.items = billitems;
       return Inv.lookupOpener("bill_payment_view", [entity: rct ]);
    }

    def viewReceipt() {
        loadBill();
        return Inv.lookupOpener("cashreceipt_preview", [entity: entity ]);
    }

    void findTxn() {
        loadBill();
    }

    public void validateBeforePost() {
        loadBill();
    }

    def summarizeByFund() {
        loadBill();
        return super.summarizeByFund();
    }    

}