package com.rameses.gov.etracs.market.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.util.*;
import com.rameses.seti2.models.*;

public class MarketCashReceiptAddBillModel {
    
    @Caller
    def caller;
    
    @Service(value="QueryService", connection="market")
    def querySvc;
    
    @Service(value="MarketBillingService", connection="market")
    def billingSvc;
    
    def receipt;
    def query = [:];
    
    def onselect;
    def selectedBill;
    
    boolean _inited_ = false;

    def billTypes = [ "RENTAL", "ELECTRICITY", "WATER" ];
    
    void init() {
          
    }
    
    def listModel = [
        fetchList: { o->
            if(!_inited_ ) return [];
            def m = [_schemaname: "vw_market_bill" ];
            def strArr = [];
            def parms = [:];
            
            if( query.acctname ) {
                strArr << "acctname LIKE :acctname";
                parms.acctname = query.acctname+"%";
            }
            if( query.unitno ) {
                strArr << "unitno LIKE :unitno";
                parms.unitno = query.unitno+"%";
            }
            if( query.ownername ) {
                strArr << "owner.name LIKE :ownername";
                parms.ownername = query.ownername+"%";
            }
            
            strArr << "billtype = :billtype";
            parms.billtype = query.billtype;

            strArr << " NOT(state = 'CLOSED') ";
            m.where = [ strArr.join(" AND "), parms ];
            m.limit = 100;
            return querySvc.getList( m );
        }
    ] as BasicListModel;
    
    def doOk() {
        if(!selectedBill) throw new Exception("Please select a bill");
        selectedBill = billingSvc.getLatestBill( [billid: selectedBill.objid, txndate: receipt.receiptdate ]);
        onselect( selectedBill );
        return "_close";
    }
    
    def doCancel() {
        return "_close";
    }
    
    void search() {
        _inited_ = true;
        listModel.reload();
    }
    
}