/*
 * Decompiled with CFR 0.152.
 */
package system.registration;

import com.rameses.util.CipherUtil;
import com.rameses.util.MachineInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class TerminalKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static String filename = ".terminal";
    private String terminalid;
    private String macaddress;

    public TerminalKey(Map map) {
        this.terminalid = (String)map.get("terminalid");
        this.macaddress = (String)map.get("macaddress");
    }

    public TerminalKey(String terminalid, String clientcode, String macaddress) {
        this.terminalid = terminalid;
        this.macaddress = macaddress;
    }

    public TerminalKey() {
    }

    public String getTerminalid() {
        return this.terminalid;
    }

    public String getMacaddress() {
        return this.macaddress;
    }

    public boolean validateMacaddress() throws Exception {
        return MachineInfo.getInstance().getMacAddress().equals(this.macaddress);
    }

    public void save() throws Exception {
        if (this.terminalid == null || this.macaddress == null) {
            throw new Exception("Error saving terminal key. Terminalid, clientcode and macaddress must not be null");
        }
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            File f = new File(filename);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("terminalid", this.terminalid);
            map.put("macaddress", this.macaddress);
            Object o = CipherUtil.encode((Serializable)map);
            fos = new FileOutputStream(f);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(o);
            oos.flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                oos.close();
            }
            catch (Exception exception) {}
            try {
                fos.close();
            }
            catch (Exception exception) {}
        }
    }

    public boolean open() throws Exception {
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        File f = new File(filename);
        if (!f.exists()) {
            return false;
        }
        try {
            fis = new FileInputStream(f);
            ois = new ObjectInputStream(fis);
            Object o = ois.readObject();
            Map map = (Map)CipherUtil.decode((Serializable)((Serializable)o));
            this.terminalid = (String)map.get("terminalid");
            this.macaddress = (String)map.get("macaddress");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                ois.close();
            }
            catch (Exception exception) {}
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
        if (!this.validateMacaddress()) {
            f.delete();
            return false;
        }
        return true;
    }

    public void delete() {
        File f = new File(filename);
        f.delete();
    }
}

