/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.util;

import com.rameses.rcp.common.StyleRule;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.support.StyleRuleParser;
import com.rameses.rcp.ui.ControlContainer;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.ui.annotations.StyleSheet;
import java.awt.Component;
import java.awt.Container;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class UIHelper {
    private static final UIHelper instance = new UIHelper();

    public static synchronized UIHelper getInstance() {
        return instance;
    }

    public static synchronized UIHelper newInstance() {
        return new UIHelper();
    }

    public static class BindingHelper {
        public static final BindingHelper instance = new BindingHelper();

        public void beforeRegister(UIControl uic) {
        }

        public void afterRegister(UIControl uic) {
        }

        public void beforeUnregister(UIControl uic) {
        }

        public void afterUnregister(UIControl uic) {
        }

        public void bind(Binding binding, Container container) {
            Component[] comps;
            for (Component c : comps = container.getComponents()) {
                this.bind(binding, c);
            }
        }

        public void bind(Binding binding, Component c) {
            if (c instanceof UIControl) {
                UIControl uic = (UIControl)((Object)c);
                if (binding == null) {
                    this.unbind(binding, c);
                } else {
                    binding.bind(uic);
                    this.beforeRegister(uic);
                    binding.register(uic);
                    this.afterRegister(uic);
                }
                if (c instanceof ControlContainer && ((ControlContainer)((Object)c)).isHasNonDynamicContents() && c instanceof Container) {
                    this.bind(binding, (Container)c);
                }
            } else if (c instanceof Container) {
                this.bind(binding, (Container)c);
            }
        }

        public void unbind(Binding binding, Component comp) {
            if (comp instanceof UIControl) {
                UIControl uic = (UIControl)((Object)comp);
                try {
                    uic.setBinding(null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.beforeUnregister(uic);
                binding.unregister(uic);
                this.afterUnregister(uic);
            }
        }

        public void loadStyleRule(Binding binding, Class pageClass) {
            Object sr;
            if (!pageClass.isAnnotationPresent(StyleSheet.class)) {
                return;
            }
            ArrayList<Object> sources = new ArrayList<Object>();
            StyleSheet ss = pageClass.getAnnotation(StyleSheet.class);
            String source = ss.value();
            if (source.trim().length() > 0) {
                if (source.indexOf(",") > -1) {
                    for (String s : source.split("\\s*,\\s*")) {
                        sources.add(s);
                    }
                } else {
                    sources.add(source);
                }
            }
            ArrayList<StyleRule> newRules = new ArrayList<StyleRule>();
            ClassLoader loader = ClientContext.getCurrentContext().getClassLoader();
            InputStream is = null;
            if (sources.size() > 0) {
                for (String string : sources) {
                    is = loader.getResourceAsStream(string);
                    sr = this.getStyles(is);
                    if (sr.size() <= 0) continue;
                    newRules.addAll((Collection<StyleRule>)sr);
                }
            } else {
                is = pageClass.getResourceAsStream(pageClass.getSimpleName() + ".style");
                List<StyleRule> sr2 = this.getStyles(is);
                if (sr2.size() > 0) {
                    newRules.addAll(sr2);
                }
            }
            StyleRule[] oldRules = binding.getStyleRules();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (oldRules != null) {
                for (StyleRule s : oldRules) {
                    arrayList.add(s);
                }
            }
            for (Object e : newRules) {
                arrayList.add((StyleRule)e);
            }
            sr = arrayList.toArray(new StyleRule[0]);
            binding.setStyleRules((StyleRule[])sr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<StyleRule> getStyles(InputStream inp) {
            if (inp != null) {
                try {
                    StyleRuleParser parser = new StyleRuleParser();
                    StyleRuleParser.DefaultParseHandler handler = new StyleRuleParser.DefaultParseHandler();
                    parser.parse(inp, handler);
                    List<StyleRule> list = handler.getList();
                    return list;
                }
                catch (Throwable throwable) {
                }
                finally {
                    try {
                        inp.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            return new ArrayList<StyleRule>();
        }
    }
}

