/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.util;

import com.rameses.rcp.util.Title;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

public class TitledPanel
extends JPanel {
    private Header header = new Header();
    private Color borderColor = Color.decode("#ADC1DC");
    private DropShadowBorder shadowBorder = new DropShadowBorder();

    public TitledPanel() {
        super.setLayout(new CustomLayout());
        this.setPreferredSize(new Dimension(100, 50));
        this.setBorder(this.shadowBorder);
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public String getTitle() {
        return this.header.getText();
    }

    public void setTitle(String title) {
        this.header.setText(title != null ? title : "");
    }

    public Font getTitleFont() {
        return this.header.getFont();
    }

    public void setTitleFont(Font font) {
        this.header.setFont(font);
    }

    public Color getHeaderBackground() {
        return this.header.getBackground();
    }

    public void setHeaderBackground(Color background) {
        this.header.setBackground(background);
    }

    @Override
    public Component add(Component comp) {
        if (this.getComponentCount() < 2) {
            this.ensureHeaderIsAdded();
            this.setOpaque(comp, true);
            comp.setBackground(Color.WHITE);
            return super.add(comp);
        }
        return comp;
    }

    @Override
    public Component add(Component comp, int index) {
        if (this.getComponentCount() < 2) {
            this.ensureHeaderIsAdded();
            this.setOpaque(comp, true);
            comp.setBackground(Color.WHITE);
            return super.add(comp, index);
        }
        return comp;
    }

    private void ensureHeaderIsAdded() {
        if (this.header.getParent() == null) {
            super.add(this.header);
        }
    }

    private void setOpaque(Component comp, boolean opaque) {
        try {
            Method m = comp.getClass().getMethod("setOpaque", Boolean.TYPE);
            m.invoke((Object)comp, opaque);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class DropShadowBorder
    extends AbstractBorder {
        private DropShadowBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = 1;
            insets.left = 1;
            insets.bottom = 3;
            insets.right = 3;
            return insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            int i;
            Color shadow = UIManager.getColor("controlShadow");
            Color oldColor = g.getColor();
            Color borderColor = TitledPanel.this.getBorderColor();
            if (borderColor != null) {
                g.setColor(borderColor);
                g.drawRect(0, 0, w - 3, h - 3);
            }
            int opacity = 40;
            for (i = 1; i <= 3; ++i) {
                g.setColor(this.createOpacity(shadow, opacity));
                g.drawLine(5 - i, h - i, w - i, h - i);
                opacity += 50;
            }
            opacity = 40;
            for (i = 1; i <= 3; ++i) {
                g.setColor(this.createOpacity(shadow, opacity));
                g.drawLine(w - i, 5 - i, w - i, h - i);
                opacity += 50;
            }
            g.setColor(oldColor);
        }

        private Color createOpacity(Color color, int opacity) {
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), opacity);
        }
    }

    private class CustomLayout
    implements LayoutManager {
        private Logger logger = Logger.getLogger(this.getClass().getName());

        private CustomLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Component body;
                Insets margin = parent.getInsets();
                int x = margin.left;
                int y = margin.top;
                int w = parent.getWidth() - (margin.left + margin.right);
                int h = parent.getHeight() - (margin.top + margin.bottom);
                Component header = this.findHeader(parent.getComponents());
                if (header != null && header.isVisible()) {
                    Dimension dim = header.getPreferredSize();
                    header.setBounds(x, y, w, dim.height);
                    y += dim.height;
                    h -= dim.height;
                }
                if ((body = this.findBody(parent.getComponents())) != null && body.isVisible()) {
                    body.setBounds(x, y, w, h);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Component body;
                Component[] comps = parent.getComponents();
                int width = 0;
                int height = 0;
                Component header = this.findHeader(comps);
                if (header != null && header.isVisible()) {
                    Dimension dim = header.getPreferredSize();
                    width = dim.width;
                    height = dim.height;
                }
                if ((body = this.findBody(comps)) != null && body.isVisible()) {
                    Dimension dim = body.getPreferredSize();
                    height += dim.height;
                }
                Insets margin = parent.getInsets();
                return new Dimension(width += margin.left + margin.right, height += margin.top + margin.bottom);
            }
        }

        Component findHeader(Component[] comps) {
            for (int i = 0; i < comps.length; ++i) {
                if (!(comps[i] instanceof Header)) continue;
                return comps[i];
            }
            return null;
        }

        Component findBody(Component[] comps) {
            for (int i = 0; i < comps.length; ++i) {
                if (comps[i] instanceof Header) continue;
                return comps[i];
            }
            return null;
        }
    }

    private class Header
    extends Title {
        Header() {
            this.setBackground(Color.decode("#BFD4F2"));
            this.setForeground(Color.decode("#022D7B"));
            this.setText("Titled Panel");
        }
    }
}

