/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.util;

import com.rameses.common.MethodResolver;
import com.rameses.common.PropertyResolver;
import com.rameses.rcp.annotations.Caller;
import com.rameses.rcp.annotations.Invoker;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.PopupMenuOpener;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.framework.ControllerProvider;
import com.rameses.rcp.framework.NavigatablePanel;
import com.rameses.rcp.framework.NavigationHandler;
import com.rameses.rcp.framework.UIController;
import com.rameses.rcp.support.ColorUtil;
import com.rameses.rcp.support.FontSupport;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.util.ValueUtil;
import java.awt.Color;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public final class ControlSupport {
    private static Object getClientProperty(Component component, Object key) {
        if (component instanceof JComponent) {
            return ((JComponent)component).getClientProperty(key);
        }
        return null;
    }

    private static void setClientProperty(Component component, Object key, Object value) {
        if (component instanceof JComponent) {
            ((JComponent)component).putClientProperty(key, value);
        }
    }

    public static void setStyles(Map props, Component component) {
        PropertyResolver resolver = PropertyResolver.getInstance();
        for (Map.Entry o : props.entrySet()) {
            Map.Entry me = o;
            if (me.getKey() == null) continue;
            String key = me.getKey().toString();
            try {
                Color oldColor;
                Color color;
                if ("background".equals(key) || "background-color".equals(key)) {
                    color = null;
                    color = me.getValue() instanceof Color ? (Color)me.getValue() : ColorUtil.decode(me.getValue() + "");
                    if (color != null) {
                        int num = 0;
                        try {
                            num = Integer.parseInt(props.get("opacity").toString());
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (num > 0) {
                            num = Math.max(num, 0);
                            num = Math.min(num, 100);
                            double orate = ((Number)num).doubleValue() / 100.0;
                            int opacity = ((Number)(orate * 255.0)).intValue();
                            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), opacity);
                        }
                    }
                    oldColor = (Color)ControlSupport.getClientProperty(component, "ControlSupport.background");
                    if (color != null) {
                        if (oldColor == null) {
                            ControlSupport.setClientProperty(component, "ControlSupport.background", component.getBackground());
                        }
                        component.setBackground(color);
                        continue;
                    }
                    if (oldColor == null) continue;
                    component.setBackground(oldColor);
                    continue;
                }
                if ("foreground".equals(key) || "color".equals(key)) {
                    color = null;
                    color = me.getValue() instanceof Color ? (Color)me.getValue() : ColorUtil.decode(me.getValue() + "");
                    oldColor = (Color)ControlSupport.getClientProperty(component, "ControlSupport.foreground");
                    if (color != null) {
                        if (oldColor == null) {
                            ControlSupport.setClientProperty(component, "ControlSupport.foreground", component.getForeground());
                        }
                        component.setForeground(color);
                        continue;
                    }
                    if (oldColor == null) continue;
                    component.setForeground(oldColor);
                    continue;
                }
                if ("repaint".equals(key)) {
                    component.repaint();
                    continue;
                }
                if ("requestFocus".equals(key) && component.isFocusable() && component.isEnabled()) {
                    component.requestFocusInWindow();
                    continue;
                }
                resolver.setProperty((Object)component, key, me.getValue());
            }
            catch (Throwable throwable) {}
        }
        try {
            if (component instanceof JComponent) {
                new FontSupport().applyStyles((JComponent)component, props);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Object init(Object bean, Map params, String action) {
        ControlSupport.setProperties(bean, params);
        return ControlSupport.invoke(bean, action, null);
    }

    public static void setProperties(Object bean, Map params) {
        if (params != null) {
            ClientContext ctx = ClientContext.getCurrentContext();
            PropertyResolver resolver = PropertyResolver.getInstance();
            Iterator iterator = params.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry oo;
                Map.Entry me = oo = iterator.next();
                try {
                    resolver.setProperty(bean, me.getKey() + "", me.getValue());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public static Object invoke(Object bean, String action, Object[] params) {
        ClientContext ctx = ClientContext.getCurrentContext();
        if (action != null && action.trim().length() > 0) {
            try {
                return MethodResolver.getInstance().invoke(bean, action, null, params);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        }
        return null;
    }

    public static void fireNavigation(UIControl source, Object outcome) {
        NavigationHandler nh = ClientContext.getCurrentContext().getNavigationHandler();
        NavigatablePanel navPanel = UIControlUtil.getParentPanel((JComponent)((Object)source), null);
        nh.navigate(navPanel, source, outcome);
    }

    public static boolean isResourceExist(String name) {
        try {
            InputStream is = ClientContext.getCurrentContext().getResourceProvider().getResource(name);
            return is != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getByteFromResource(String name) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        ByteArrayOutputStream bos = null;
        InputStream is = ClientContext.getCurrentContext().getResourceProvider().getResource(name);
        if (is != null) {
            try {
                bos = new ByteArrayOutputStream();
                int i = 0;
                while ((i = is.read()) != -1) {
                    bos.write(i);
                }
                byte[] byArray = bos.toByteArray();
                return byArray;
            }
            catch (Exception ex) {
                byte[] byArray = null;
                return byArray;
            }
            finally {
                try {
                    bos.close();
                }
                catch (Exception exception) {}
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    public static ImageIcon getImageIcon(String name) {
        byte[] b = ControlSupport.getByteFromResource(name);
        if (b != null) {
            return new ImageIcon(b);
        }
        return null;
    }

    public static Opener initOpener(Opener opener, UIController caller) {
        return ControlSupport.initOpener(opener, caller, true);
    }

    public static Opener initOpener(Opener opener, UIController caller, boolean invokeOpenerAction) {
        UIController controller;
        Object invoker = opener.getProperties().get("_INVOKER_");
        if (caller != null && ValueUtil.isEmpty((Object)opener.getName())) {
            opener.setController(caller);
            if (opener.getCaption() != null) {
                caller.setTitle(opener.getCaption());
            }
            if (opener.getId() != null) {
                caller.setId(opener.getId());
            }
        } else if (opener.getController() == null) {
            ControllerProvider provider = ClientContext.getCurrentContext().getControllerProvider();
            UIController controller2 = provider.getController(opener.getName(), caller);
            controller2.setId(opener.getId());
            controller2.setName(opener.getName());
            controller2.setTitle(opener.getCaption());
            Object callee = controller2.getCodeBean();
            if (caller != null) {
                ControlSupport.injectCaller(callee, callee.getClass(), caller.getCodeBean());
            }
            if (invoker != null) {
                ControlSupport.injectInvoker(callee, callee.getClass(), invoker);
            }
            opener.setController(controller2);
            if (invokeOpenerAction) {
                Object o;
                Object[] actionParams = new Object[]{};
                if (invoker != null) {
                    actionParams = new Object[]{invoker};
                }
                if ((o = opener.getController().init(opener.getParams(), opener.getAction(), actionParams)) != null) {
                    if (o instanceof String) {
                        opener.setOutcome((String)o);
                    } else {
                        if (o instanceof PopupMenuOpener) {
                            opener = (Opener)o;
                            return opener;
                        }
                        if (o instanceof Opener) {
                            Opener oo = (Opener)o;
                            opener = ControlSupport.initOpener(oo, oo.getController(), invokeOpenerAction);
                        }
                    }
                }
            }
        }
        if ((controller = opener.getController()).getTitle() == null) {
            controller.setTitle(controller.getName());
        }
        return opener;
    }

    public static void injectCaller(Object callee, Class clazz, Object caller) {
        Class superClass;
        if (callee != null && callee.equals(caller)) {
            return;
        }
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.isAnnotationPresent(Caller.class)) continue;
            boolean accessible = f.isAccessible();
            f.setAccessible(true);
            try {
                f.set(callee, caller);
            }
            catch (Exception exception) {
                // empty catch block
            }
            f.setAccessible(accessible);
            break;
        }
        if ((superClass = clazz.getSuperclass()) != null) {
            ControlSupport.injectCaller(callee, superClass, caller);
        }
    }

    public static void injectInvoker(Object object, Class clazz, Object invoker) {
        Class superClass;
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.isAnnotationPresent(Invoker.class)) continue;
            boolean accessible = f.isAccessible();
            f.setAccessible(true);
            try {
                f.set(object, invoker);
            }
            catch (Exception exception) {
                // empty catch block
            }
            f.setAccessible(accessible);
            break;
        }
        if ((superClass = clazz.getSuperclass()) != null) {
            ControlSupport.injectInvoker(object, superClass, invoker);
        }
    }

    public static boolean isPermitted(String domain, String role, String permission) {
        ClientContext ctx = ClientContext.getCurrentContext();
        if (ctx.getSecurityProvider() == null) {
            return true;
        }
        return ctx.getSecurityProvider().checkPermission(domain, role, permission);
    }

    public static boolean hasMethod(Object bean, String name, Object[] args) {
        if (bean == null || name == null) {
            return false;
        }
        for (Class<?> beanClass = bean.getClass(); beanClass != null; beanClass = beanClass.getSuperclass()) {
            Method[] methods = beanClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                int argSize;
                Method m = methods[i];
                if (!m.getName().equals(name)) continue;
                int paramSize = m.getParameterTypes() == null ? 0 : m.getParameterTypes().length;
                int n = argSize = args == null ? 0 : args.length;
                if (paramSize == argSize && paramSize == 0) {
                    return true;
                }
                if (paramSize != argSize || m.getParameterTypes()[0] != Object.class) continue;
                return true;
            }
        }
        return false;
    }
}

