/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.swing;

import com.rameses.rcp.common.AbstractListDataProvider;
import com.rameses.rcp.common.ListItem;
import com.rameses.rcp.common.PropertyChangeHandler;
import com.rameses.rcp.common.ScrollListModel;
import com.rameses.rcp.common.TableModelHandler;
import com.rameses.rcp.support.ColorUtil;
import com.rameses.rcp.swing.ListModel;
import com.rameses.rcp.swing.ListScrollBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public class ScrollableListPane
extends JPanel {
    private ListScrollBar scrollBar;
    private JScrollPane scrollPane;
    private JListImpl jList;
    private ScrollListModelImpl scrollModel;
    private AbstractListDataProvider model;
    private Object modelObject;
    private int fixedCellHeight;
    private List<Handler> handlers = new ArrayList<Handler>();

    public ScrollableListPane() {
        this.initComponent();
    }

    private void initComponent() {
        this.jList = new JListImpl();
        this.fixedCellHeight = this.jList.getFixedCellHeight();
        this.scrollBar = new ListScrollBar();
        this.scrollPane = new JScrollPane(this.jList);
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.setViewport(new ViewportImpl(this.jList));
        super.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)new ScrollBarPanel(this.scrollBar), "East");
        this.jList.setCellRenderer(new CellRendererImpl());
        this.jList.addMouseListener(new ListMouseHandler());
        this.jList.addMouseWheelListener(new ListMouseHandler());
        this.jList.addKeyListener(new TableKeyAdapter());
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    public AbstractListDataProvider getModel() {
        return this.model;
    }

    public void setModel(AbstractListDataProvider model) {
        this.model = model;
        this.modelObject = model;
        this.fireModelChanged();
    }

    public void setModel(Object modelObject) {
        this.model = (AbstractListDataProvider)modelObject;
        this.modelObject = modelObject;
        this.fireModelChanged();
    }

    public void setCellHeight(int cellHeight) {
        if (this.jList == null) {
            return;
        }
        if (cellHeight > 0) {
            this.jList.setFixedCellHeight(cellHeight);
        } else {
            this.jList.setFixedCellHeight(this.fixedCellHeight);
        }
    }

    private void fireModelChanged() {
        AbstractListDataProvider model = this.getModel();
        this.scrollModel = new ScrollListModelImpl();
        this.scrollBar.setDataProvider(this.scrollModel);
        this.jList.setModel(new ListModel(this.scrollModel));
        this.scrollModel.addHandler(new PropertyChangeHandlerImpl());
        this.scrollModel.load();
        this.scrollModel.addHandler(new TableModelHandlerImpl());
        this.scrollBar.adjustValues();
    }

    protected String getItemText(Object item) {
        return item == null ? null : item.toString();
    }

    @Override
    public void requestFocus() {
        this.jList.requestFocus();
    }

    public void removeHandler(Handler handler) {
        if (handler != null) {
            this.handlers.remove(handler);
        }
    }

    public void addHandler(Handler handler) {
        if (handler == null) {
            return;
        }
        if (!this.handlers.contains(handler)) {
            this.handlers.add(handler);
        }
    }

    private void notifyOnSelect(ListItem li) {
        Object item;
        Object object = item = li == null ? null : li.getItem();
        if (item == null) {
            return;
        }
        for (Handler handler : this.handlers) {
            handler.onselect(item);
        }
    }

    private class OnselectNotifier
    implements Runnable {
        ScrollableListPane root;
        private ListItem item;

        OnselectNotifier(ListItem item) {
            this.root = ScrollableListPane.this;
            this.item = item;
        }

        @Override
        public void run() {
            if (this.item == null) {
                return;
            }
            this.root.notifyOnSelect(this.item);
        }
    }

    public static interface Handler {
        public void onselect(Object var1);
    }

    private class TableKeyAdapter
    extends KeyAdapter {
        ScrollableListPane root;

        private TableKeyAdapter() {
            this.root = ScrollableListPane.this;
        }

        private void scroll() {
            JListImpl jList = this.root.jList;
            try {
                int selIndex = jList.getSelectedIndex();
                Rectangle rect = jList.getCellBounds(selIndex, selIndex);
                this.root.scrollBar.adjustValues();
                jList.scrollRectToVisible(rect);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            ScrollListModelImpl model = this.root.scrollModel;
            if (model == null) {
                return;
            }
            int index = this.root.jList.getSelectedIndex();
            if (index < 0) {
                return;
            }
            switch (e.getKeyCode()) {
                case 40: {
                    e.consume();
                    model.moveNextRecord();
                    this.scroll();
                    break;
                }
                case 38: {
                    e.consume();
                    model.moveBackRecord();
                    this.scroll();
                    break;
                }
                case 10: {
                    ScrollableListPane.this.notifyOnSelect(model.getListItem(index));
                    break;
                }
                case 34: {
                    e.consume();
                    break;
                }
                case 33: {
                    e.consume();
                    break;
                }
                case 36: {
                    e.consume();
                    break;
                }
                case 35: {
                    e.consume();
                }
            }
        }
    }

    private class TableModelHandlerImpl
    implements TableModelHandler {
        ScrollableListPane root;

        private TableModelHandlerImpl() {
            this.root = ScrollableListPane.this;
        }

        @Override
        public void fireTableCellUpdated(int row, int column) {
        }

        @Override
        public void fireTableRowsDeleted(int firstRow, int lastRow) {
        }

        @Override
        public void fireTableRowsInserted(int firstRow, int lastRow) {
        }

        @Override
        public void fireTableRowsUpdated(int firstRow, int lastRow) {
        }

        @Override
        public void fireTableDataProviderChanged() {
        }

        @Override
        public void fireTableStructureChanged() {
            this.root.jList.repaint();
        }

        @Override
        public void fireTableDataChanged() {
            this.root.jList.repaint();
        }

        @Override
        public void fireTableRowSelected(int row, boolean focusOnItemDataOnly) {
        }
    }

    private class PropertyChangeHandlerImpl
    implements PropertyChangeHandler {
        ScrollableListPane root;

        private PropertyChangeHandlerImpl() {
            this.root = ScrollableListPane.this;
        }

        @Override
        public void firePropertyChange(String name, int value) {
        }

        @Override
        public void firePropertyChange(String name, boolean value) {
            if ("loading".equals(name)) {
                this.root.scrollBar.setEnabled(!value);
            }
        }

        @Override
        public void firePropertyChange(String name, String value) {
        }

        @Override
        public void firePropertyChange(String name, Object value) {
            if ("selectedItemChanged".equals(name)) {
                ScrollListModelImpl slm = this.root.scrollModel;
                ListItem li = slm.getSelectedItem();
                if (li == null) {
                    return;
                }
                int index = li.getIndex();
                this.root.jList.setSelectedIndex(index);
                this.root.jList.ensureIndexIsVisible(index);
                this.root.scrollBar.adjustValues();
            }
        }
    }

    private class ListMouseHandler
    implements MouseWheelListener,
    MouseListener {
        ScrollableListPane root;

        private ListMouseHandler() {
            this.root = ScrollableListPane.this;
        }

        private void scroll() {
            JListImpl jList = this.root.jList;
            try {
                int selIndex = jList.getSelectedIndex();
                ListItem li = this.root.scrollModel.getListItem(selIndex);
                this.root.scrollBar.adjustValue(li.getRownum());
                Rectangle rect = jList.getCellBounds(selIndex, selIndex);
                jList.scrollRectToVisible(rect);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            ScrollListModelImpl model = this.root.scrollModel;
            if (model == null) {
                return;
            }
            if (model.isProcessing()) {
                return;
            }
            int rotation = e.getWheelRotation();
            if (rotation == 0) {
                return;
            }
            if (rotation < 0) {
                model.moveBackRecord();
            } else {
                model.moveNextRecord(true);
            }
            this.scroll();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.root.scrollModel == null) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (e.getClickCount() == 2) {
                return;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.root.scrollModel == null) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            int index = this.root.jList.getSelectedIndex();
            if (index < 0) {
                return;
            }
            this.root.scrollModel.setSelectedItem(index);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.root.scrollModel == null) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (e.getClickCount() == 2) {
                return;
            }
            int index = this.root.jList.getSelectedIndex();
            ListItem li = this.root.scrollModel.getListItem(index);
            EventQueue.invokeLater(new OnselectNotifier(li));
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class CellRendererImpl
    implements ListCellRenderer {
        ScrollableListPane root;
        private JLabel label;

        CellRendererImpl() {
            this.root = ScrollableListPane.this;
            this.label = new JLabel();
            this.label.setOpaque(true);
            this.label.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        }

        public Component getListCellRendererComponent(JList jlist, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.label.setOpaque(true);
                this.label.setBackground(jlist.getSelectionBackground());
                this.label.setForeground(jlist.getSelectionForeground());
            } else {
                this.label.setOpaque(false);
                this.label.setForeground(jlist.getForeground());
            }
            String text = this.root.getItemText(value);
            this.label.setText(text == null ? " " : text);
            return this.label;
        }
    }

    private class ScrollListModelImpl
    extends ScrollListModel {
        ScrollableListPane root;

        private ScrollListModelImpl() {
            this.root = ScrollableListPane.this;
        }

        @Override
        public List fetchList(Map params) {
            AbstractListDataProvider model = this.root.getModel();
            if (model == null) {
                return null;
            }
            return model.fetchList(params);
        }
    }

    private class ScrollBarPanel
    extends JPanel {
        ScrollableListPane root;
        private Rectangle oldBounds;

        ScrollBarPanel(ListScrollBar scrollBar) {
            this.root = ScrollableListPane.this;
            this.oldBounds = new Rectangle();
            Dimension ps = scrollBar.getPreferredSize();
            this.setPreferredSize(ps);
            this.setLayout(new BorderLayout());
            scrollBar.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String propName = evt.getPropertyName();
                    if ("visible".equals(propName)) {
                        Boolean visible = (Boolean)evt.getNewValue();
                        ScrollBarPanel.this.setVisible(visible);
                    }
                }
            });
            this.setVisible(scrollBar.isVisible());
            this.add((Component)scrollBar, "Center");
        }
    }

    private class ViewportImpl
    extends JViewport {
        ScrollableListPane root;
        private Color defaultBgcolor;
        private Color bgcolor;
        private Rectangle oldBounds;

        ViewportImpl(Component view) {
            this.root = ScrollableListPane.this;
            this.defaultBgcolor = SystemColor.control;
            this.bgcolor = Color.WHITE;
            this.oldBounds = new Rectangle();
            super.setBackground(this.bgcolor);
            super.setOpaque(true);
            super.setView(view);
            this.addComponentListener(new ComponentListener(){

                @Override
                public void componentHidden(ComponentEvent e) {
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentShown(ComponentEvent e) {
                }

                @Override
                public void componentResized(ComponentEvent e) {
                    Rectangle rect = ViewportImpl.this.getBounds();
                    if (rect.height == ((ViewportImpl)ViewportImpl.this).oldBounds.height) {
                        return;
                    }
                    ViewportImpl.this.oldBounds = rect;
                    boolean dynamic = ViewportImpl.this.root.scrollBar.isDynamicallyVisible();
                    if (rect.height < ((ScrollableListPane)ViewportImpl.this.root).jList.getBounds().height && !dynamic) {
                        ScrollableListPane.this.scrollPane.setVerticalScrollBarPolicy(20);
                    } else {
                        ScrollableListPane.this.scrollPane.setVerticalScrollBarPolicy(21);
                    }
                }
            });
        }

        @Override
        public void setBackground(Color bg) {
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Color newColor = ColorUtil.brighter(this.defaultBgcolor.darker(), 20);
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setColor(newColor);
            g2.drawLine(0, 0, 0, this.getHeight());
            g2.dispose();
        }
    }

    private class JListImpl
    extends JList {
        ScrollableListPane root;

        JListImpl() {
            this.root = ScrollableListPane.this;
        }

        @Override
        public void setSelectedIndex(int index) {
            super.setSelectedIndex(index);
        }

        @Override
        protected void fireSelectionValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
            super.fireSelectionValueChanged(firstIndex, lastIndex, isAdjusting);
        }

        @Override
        public void addSelectionInterval(int anchor, int lead) {
            super.addSelectionInterval(anchor, lead);
        }
    }
}

