/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.swing;

import com.rameses.rcp.common.DocViewModel;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.support.ColorUtil;
import com.rameses.rcp.support.FontSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.Beans;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.ComponentView;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class HtmlViewPane
extends JEditorPane {
    private String fontStyle;
    private Point mousePoint;
    private DocViewModel docModel;
    private Font templateFont;
    private ArrayList<ActionParam> actionParams;

    public HtmlViewPane() {
        super.setEditable(false);
        super.setContentType("text/html");
        this.actionParams = new ArrayList();
        CompEditorKit editorKit = new CompEditorKit();
        Document doc = editorKit.createDefaultDocument();
        super.setEditorKit(editorKit);
        super.setDocument(doc);
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                HtmlViewPane.this.hyperlinkUpdateImpl(e);
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HtmlViewPane.this.mouseClickedImpl(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                HtmlViewPane.this.mousePoint = e.getPoint();
            }
        });
        try {
            this.templateFont = UIManager.getLookAndFeelDefaults().getFont("TextField.font");
            this.templateFont = new Font(this.templateFont.getFontName(), this.templateFont.getStyle(), this.templateFont.getSize() + 1);
            super.setFont(this.templateFont);
            this.updateStyleSheet();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setMargin(new Insets(5, 5, 5, 5));
        if (Beans.isDesignTime()) {
            this.setPreferredSize(new Dimension(100, 50));
        }
        this.afterInit();
    }

    protected void afterInit() {
    }

    protected Point getMousePoint() {
        return this.mousePoint;
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
        new FontSupport().applyStyles((JComponent)this, fontStyle);
        this.updateStyleSheet();
    }

    @Override
    public void setDocument(Document doc) {
        try {
            ClassLoader cloader;
            URL url;
            if (doc instanceof HTMLDocument && (url = (cloader = ClientContext.getCurrentContext().getClassLoader()).getResource("images")) != null) {
                ((HTMLDocument)doc).setBase(url);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.setDocument(doc);
    }

    @Override
    public void setVisible(boolean visible) {
        Container parent = this.getParent();
        if (parent instanceof JViewport && (parent = parent.getParent()) instanceof JScrollPane) {
            parent.setVisible(visible);
            return;
        }
        super.setVisible(visible);
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        return doc.getStyleSheet();
    }

    protected void processAction(String name, Map params) {
    }

    private void hyperlinkUpdateImpl(HyperlinkEvent e) {
        if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        AttributeSet aset = e.getSourceElement().getAttributes();
        Enumeration<?> en = aset.getAttributeNames();
        while (en.hasMoreElements()) {
            Object k = en.nextElement();
            Object v = aset.getAttribute(k);
            if (!(v instanceof AttributeSet)) continue;
            AttributeSet vset = (AttributeSet)v;
            Enumeration<?> ven = vset.getAttributeNames();
            while (ven.hasMoreElements()) {
                Object vk = ven.nextElement();
                Object vv = vset.getAttribute(vk);
                params.put(vk.toString(), vv);
            }
        }
        Object href = params.get("href");
        if (href == null) {
            return;
        }
        String shref = href.toString();
        if (!shref.matches("[a-zA-Z0-9_]{1,}")) {
            return;
        }
        this.actionParams.add(new ActionParam(shref, params));
    }

    private void mouseClickedImpl(MouseEvent e) {
        if (e != null && e.getClickCount() == 1 && !this.actionParams.isEmpty()) {
            ActionParam ap = this.actionParams.get(0);
            this.actionParams.clear();
            this.processAction(ap.name, ap.param);
        }
        this.actionParams.clear();
    }

    private void updateStyleSheet() {
        EditorKit kit = this.getEditorKit();
        if (kit instanceof HTMLEditorKit) {
            HTMLEditorKit htmlkit = (HTMLEditorKit)kit;
            StyleSheet ss = htmlkit.getStyleSheet();
            Font font = this.getFont();
            if (font != null) {
                ss.addRule("html {font-family:" + font.getFontName() + "; font-size:" + font.getSize() + ";}");
                ss.addRule("body {font-family:" + font.getFontName() + "; font-size:" + font.getSize() + ";}");
            }
        }
    }

    class CSSInfo {
        private Element elem;
        private Map map;

        CSSInfo(Element elem, Map map) {
            this.elem = elem;
            this.map = map;
        }

        boolean containsKey(Object name) {
            return this.map.containsKey(name);
        }

        Object get(Object name) {
            return this.map == null ? null : this.map.get(name);
        }

        String getString(Object name) {
            Object value = this.get(name);
            return value == null ? null : value.toString();
        }

        Integer getInteger(Object name) {
            return this.getInteger(name, null);
        }

        Integer getInteger(Object name, Integer defaultValue) {
            try {
                return new Integer(this.get(name).toString());
            }
            catch (Throwable t) {
                return defaultValue;
            }
        }

        Insets getInsets(Object name) {
            Integer top = this.getInteger(name + "-top");
            Integer left = this.getInteger(name + "-left");
            Integer bottom = this.getInteger(name + "-bottom");
            Integer right = this.getInteger(name + "-right");
            if (top == null && left == null && bottom == null && right == null) {
                return null;
            }
            if (top == null) {
                top = 0;
            }
            if (left == null) {
                left = 0;
            }
            if (bottom == null) {
                bottom = 0;
            }
            if (right == null) {
                right = 0;
            }
            return new Insets(top, left, bottom, right);
        }

        Color getColor() {
            try {
                Object o = this.elem.getAttributes().getAttribute(CSS.Attribute.COLOR);
                return ColorUtil.decode(o.toString());
            }
            catch (Throwable t) {
                return null;
            }
        }

        Color getBackground() {
            try {
                Object o = this.elem.getAttributes().getAttribute(CSS.Attribute.BACKGROUND_COLOR);
                return ColorUtil.decode(o.toString());
            }
            catch (Throwable t) {
                return null;
            }
        }

        int getTextAlign() {
            Object o = this.elem.getAttributes().getAttribute(CSS.Attribute.TEXT_ALIGN);
            if (o == null) {
                return -1;
            }
            String sval = o.toString();
            if (sval.equals("left")) {
                return 2;
            }
            if (sval.equals("center")) {
                return 0;
            }
            if (sval.equals("right")) {
                return 4;
            }
            return -1;
        }

        int getVerticalAlign() {
            Object o = this.elem.getAttributes().getAttribute(CSS.Attribute.VERTICAL_ALIGN);
            if (o == null) {
                return -1;
            }
            String sval = o.toString();
            if (sval.equals("top")) {
                return 1;
            }
            if (sval.equals("center")) {
                return 0;
            }
            if (sval.equals("bottom")) {
                return 3;
            }
            return -1;
        }

        int getWidth() {
            try {
                Object o = this.elem.getAttributes().getAttribute(CSS.Attribute.WIDTH);
                return Integer.parseInt(o.toString());
            }
            catch (Throwable t) {
                return -1;
            }
        }

        int getHeight() {
            try {
                Object o = this.elem.getAttributes().getAttribute(CSS.Attribute.HEIGHT);
                return Integer.parseInt(o.toString());
            }
            catch (Throwable t) {
                return -1;
            }
        }
    }

    class TagInfo {
        private Element elem;
        private Map attrs;
        private Map css;
        private CSSInfo cssinfo;

        public TagInfo(Element elem) {
            this.elem = elem;
        }

        void parse() {
            this.attrs = new HashMap();
            this.css = new HashMap();
            AttributeSet aset = this.elem.getAttributes();
            Enumeration<?> en = aset.getAttributeNames();
            while (en.hasMoreElements()) {
                Object k = en.nextElement();
                Object v = aset.getAttribute(k);
                if (v == null) continue;
                if (k instanceof HTML.Attribute) {
                    this.attrs.put(k.toString(), v.toString());
                    continue;
                }
                if (k instanceof CSS.Attribute) {
                    this.css.put(k.toString(), v.toString());
                    continue;
                }
                this.attrs.put(k.toString(), v.toString());
            }
            this.cssinfo = new CSSInfo(this.elem, this.css);
        }

        CSSInfo getCSSInfo() {
            return this.cssinfo;
        }

        Map getProperties() {
            return this.attrs;
        }

        Object get(Object name) {
            return this.attrs == null ? null : this.attrs.get(name);
        }

        String getString(Object name) {
            Object value = this.get(name);
            return value == null ? null : value.toString();
        }

        Integer getInteger(Object name) {
            return this.getInteger(name, null);
        }

        Integer getInteger(Object name, Integer defaultValue) {
            try {
                return new Integer(this.get(name).toString());
            }
            catch (Throwable t) {
                return defaultValue;
            }
        }
    }

    class ButtonView
    extends ComponentView
    implements ActionListener {
        private TagInfo taginfo;

        public ButtonView(Element element, TagInfo taginfo) {
            super(element);
            this.taginfo = taginfo;
        }

        @Override
        protected Component createComponent() {
            Color color;
            CSSInfo css;
            Integer border;
            JButton button = new JButton();
            button.setText(this.taginfo.getString("value"));
            button.addActionListener(this);
            StyleSheet sheet = HtmlViewPane.this.getStyleSheet();
            Font font = sheet.getFont(this.getAttributes());
            if (font != null) {
                button.setFont(font);
            }
            if ((border = (css = this.taginfo.getCSSInfo()).getInteger("border", 1)) == 0) {
                button.setContentAreaFilled(false);
                button.setBorderPainted(false);
            } else {
                button.setContentAreaFilled(true);
                button.setBorderPainted(true);
            }
            Insets padding = css.getInsets("padding");
            if (padding != null) {
                button.setMargin(padding);
            }
            if ((color = css.getColor()) != null) {
                button.setForeground(color);
            }
            if ((color = css.getBackground()) != null) {
                button.setBackground(color);
            }
            return button;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Map params = this.taginfo.getProperties();
            Object obj = params.get("onclick");
            HtmlViewPane.this.processAction(obj == null ? null : obj.toString(), params);
        }
    }

    class CompFactory
    extends HTMLEditorKit.HTMLFactory {
        @Override
        public View create(Element element) {
            HTML.Tag tag;
            Object o;
            AttributeSet attrs = element.getAttributes();
            Object elementName = attrs.getAttribute("$ename");
            Object object = o = elementName != null ? null : attrs.getAttribute(StyleConstants.NameAttribute);
            if (o instanceof HTML.Tag && (tag = (HTML.Tag)o) == HTML.Tag.INPUT) {
                TagInfo taginfo = new TagInfo(element);
                taginfo.parse();
                if ("button".equals(taginfo.getString("type"))) {
                    return new ButtonView(element, taginfo);
                }
            }
            return super.create(element);
        }
    }

    class CompEditorKit
    extends HTMLEditorKit {
        CompEditorKit() {
        }

        @Override
        public ViewFactory getViewFactory() {
            return new CompFactory();
        }
    }

    private class ActionParam {
        private String name;
        private Map param;

        ActionParam(String name, Map param) {
            this.name = name;
            this.param = param;
        }
    }
}

