/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.support;

import com.rameses.rcp.support.ThemeUI;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.text.JTextComponent;

public class TextEditorSupport {
    private JTextComponent component;

    public static TextEditorSupport install(JTextComponent component) {
        TextEditorSupport s = new TextEditorSupport(component);
        component.putClientProperty(TextEditorSupport.class, s);
        return s;
    }

    private TextEditorSupport(JTextComponent component) {
        this.component = component;
        component.setMargin(new Insets(1, 5, 2, 4));
        component.addFocusListener(new SupportFocusListener());
        component.putClientProperty("TextField.focusBackground", ThemeUI.getColor("XTextField.focusBackground"));
    }

    private class SupportFocusListener
    implements FocusListener {
        private SupportFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            TextEditorSupport.this.component.selectAll();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

