/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.support;

import com.rameses.platform.interfaces.ContentPane;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.ui.UIControl;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.Beans;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComponent;

public class MouseEventSupport
implements MouseListener {
    private JComponent component;
    private UIControl uicontrol;
    private boolean processing;

    public MouseEventSupport(JComponent component) {
        this.component = component;
        if (component instanceof UIControl) {
            this.uicontrol = (UIControl)((Object)component);
        }
    }

    public MouseEventSupport(JComponent component, UIControl uicontrol) {
        this.component = component;
        this.uicontrol = uicontrol;
    }

    public void install() {
        if (Beans.isDesignTime()) {
            return;
        }
        this.uninstall();
        if (!(this.component instanceof AbstractButton)) {
            this.component.addMouseListener(this);
        }
    }

    public void uninstall() {
        MouseListener[] listeners;
        for (MouseListener ml : listeners = this.component.getMouseListeners()) {
            if (!(ml instanceof MouseEventSupport)) continue;
            this.component.removeMouseListener(ml);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.processing) {
            return;
        }
        if (e.getClickCount() != 1) {
            return;
        }
        if (!e.isControlDown() || !e.isShiftDown()) {
            return;
        }
        this.processing = true;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    MouseEventSupport.this.showComponentInfo();
                }
                catch (Throwable t) {
                    MsgBox.err(t);
                }
                finally {
                    MouseEventSupport.this.processing = false;
                }
            }
        });
    }

    public void showComponentInfo() {
        if (this.uicontrol == null) {
            return;
        }
        Binding binding = this.uicontrol.getBinding();
        if (binding == null) {
            return;
        }
        HashMap<String, Map> params = new HashMap<String, Map>();
        params.put("properties", this.getInfo(binding.getBean()));
        Component uic = (Component)((Object)this.uicontrol);
        Component fc = this.findComponent(uic, ContentPane.View.class);
        if (fc instanceof ContentPane.View) {
            Map info = ((ContentPane.View)((Object)fc)).getInfo();
            params.put("info", info == null ? new HashMap() : info);
        }
        Opener opener = null;
        try {
            opener = ClientContext.getCurrentContext().getOpenerProvider().lookupOpener("ui-control-info:show", params);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (opener != null) {
            binding.fireNavigation(opener);
        }
    }

    private Map getInfo(Object bean) {
        Map props;
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        if (this.uicontrol == null) {
            return info;
        }
        info.put("controlClass", this.uicontrol.getClass().getSimpleName());
        info.put("beanClass", bean == null ? null : bean.getClass().getSimpleName());
        info.put("name", this.uicontrol.getName());
        info.put("index", this.uicontrol.getIndex());
        String[] depends = this.uicontrol.getDepends();
        if (depends != null) {
            StringBuffer sb = new StringBuffer();
            for (String str : depends) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(str);
            }
            info.put("depends", sb.toString());
        } else {
            info.put("depends", null);
        }
        if (this.uicontrol instanceof ComponentInfo && (props = ((ComponentInfo)((Object)this.uicontrol)).getInfo()) != null) {
            props.remove("name");
            props.remove("index");
            props.remove("depends");
            info.putAll(props);
        }
        return info;
    }

    private Component findComponent(Component source, Class componentClass) {
        if (source == null || componentClass == null) {
            return null;
        }
        for (Container parent = source.getParent(); parent != null; parent = parent.getParent()) {
            if (!componentClass.isInstance(parent)) continue;
            return parent;
        }
        return null;
    }

    public static interface ComponentInfo {
        public Map getInfo();
    }
}

