/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.support;

import com.rameses.rcp.common.FormControl;
import com.rameses.rcp.control.border.XUnderlineBorder;
import com.rameses.rcp.util.FormControlUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class FormSupport {
    public static final String CATEGORY_LABEL = "__category_label";

    public static List<FormControl> buildFormControls(List<Map> infos) {
        return FormSupport.buildFormControls(infos, (List<Map>)null, null);
    }

    public static List<FormControl> buildFormControls(List<Map> infos, List<Map> categories) {
        return FormSupport.buildFormControls(infos, categories, null);
    }

    public static List<FormControl> buildFormControls(List<Map> infos, String entityVarName) {
        return FormSupport.buildFormControls(infos, null, entityVarName);
    }

    public static List<FormControl> buildFormControls(List<Map> infos, List<Map> categories, String entityVarName) {
        ArrayList<FormControl> list = new ArrayList<FormControl>();
        List<Map> items = null;
        HashMap<String, ArrayList<Map>> categoryItems = null;
        if (infos == null) {
            infos = new ArrayList<Map>();
        } else if (categories != null) {
            items = new ArrayList<Map>(infos);
            categoryItems = new HashMap<String, ArrayList<Map>>();
            Iterator<Map> itr = items.iterator();
            while (itr.hasNext()) {
                Map elm = itr.next();
                String catId = (String)elm.get("category");
                if (catId == null) continue;
                itr.remove();
                ArrayList<Map> ci = (ArrayList<Map>)categoryItems.get(catId);
                if (ci == null) {
                    ci = new ArrayList<Map>();
                    categoryItems.put(catId, ci);
                }
                ci.add(elm);
            }
        } else {
            items = infos;
        }
        for (Map m : items) {
            FormSupport.addFormControl(list, m, entityVarName);
        }
        if (categories != null && categoryItems != null) {
            boolean first = items.isEmpty();
            for (Map cat : categories) {
                List ciList = (List)categoryItems.get(cat.get("name"));
                if (ciList == null) continue;
                FormControl fc = new FormControl();
                fc.setType("label");
                Map props = fc.getProperties();
                props.put("name", CATEGORY_LABEL);
                props.put("text", "<html><b>" + cat.get("caption") + "</b></html>");
                props.put("foreground", Color.RED);
                Dimension prefSize = null;
                Insets padding = null;
                if (first) {
                    padding = new Insets(0, 0, 0, 0);
                    prefSize = new Dimension(0, 20);
                } else {
                    padding = new Insets(10, 0, 0, 0);
                    prefSize = new Dimension(0, 30);
                }
                props.put("padding", padding);
                props.put("showCaption", false);
                props.put("border", new XUnderlineBorder());
                props.put("preferredSize", prefSize);
                props.put("verticalAlignment", 1);
                HashMap ext = new HashMap(cat);
                ext.remove("name");
                ext.remove("caption");
                if (!ext.isEmpty()) {
                    props.putAll(ext);
                }
                list.add(fc);
                for (Map m : ciList) {
                    FormSupport.addFormControl(list, m, entityVarName);
                }
                first = false;
            }
        }
        return list;
    }

    private static void addFormControl(List list, Map m, String entityVarName) {
        HashMap<String, String> nm = new HashMap<String, String>();
        nm.putAll(m);
        String mode = (String)nm.remove("mode");
        if (mode != null && mode.equals("hidden")) {
            return;
        }
        String name = (String)nm.remove("name");
        String type = (String)nm.remove("type");
        if (type == null) {
            type = "text";
        }
        if (entityVarName != null && entityVarName.trim().length() > 0) {
            name = entityVarName + "." + name;
        }
        nm.put("name", name);
        FormControl fc = new FormControl();
        fc.setType(type);
        fc.setProperties(nm);
        list.add(fc);
    }

    public static List<FormControl> buildFormControls(List<Map> infos, String entityVarName, Map entityMap) {
        List<FormControl> controls = FormSupport.buildFormControls(infos, entityVarName);
        return FormSupport.filterFormControls(controls, entityMap, entityVarName);
    }

    public static List<FormControl> buildFormControls(List<Map> infos, String entityVarName, Map entityMap, Map extProps) {
        List<FormControl> controls = FormSupport.buildFormControls(infos, entityVarName);
        return FormSupport.filterFormControls(controls, entityMap, entityVarName, extProps);
    }

    public static List<FormControl> buildFormControls(List<Map> infos, List<Map> meta, String entityVarName, Map entityMap, Map extProps) {
        List<FormControl> controls = FormSupport.buildFormControls(infos, meta, entityVarName);
        return FormSupport.filterFormControls(controls, entityMap, entityVarName, extProps);
    }

    public static List<FormControl> filterFormControls(List<FormControl> controls, Map entityMap) {
        return FormSupport.filterFormControls(controls, entityMap, null, null);
    }

    public static List<FormControl> filterFormControls(List<FormControl> controls, Map entityMap, String entityVarName) {
        return FormSupport.filterFormControls(controls, entityMap, entityVarName, null);
    }

    public static List<FormControl> filterFormControls(List<FormControl> controls, Map entityMap, String entityVarName, Map extProps) {
        FormControl fc;
        ArrayList<FormControl> list = new ArrayList<FormControl>();
        ArrayList<FormControl> labels = new ArrayList<FormControl>();
        for (FormControl fc2 : controls) {
            String name = (String)fc2.getProperties().get("name");
            if (CATEGORY_LABEL.equals(name)) {
                list.add(fc2);
                labels.add(fc2);
                continue;
            }
            if (entityVarName != null && entityVarName.trim().length() > 0) {
                name = name.replaceAll(entityVarName + "\\.", "");
            }
            if (!entityMap.containsKey(name)) continue;
            FormControl f = fc2;
            if (extProps != null) {
                HashMap newProps = new HashMap();
                newProps.putAll(f.getProperties());
                newProps.putAll(extProps);
                f = new FormControl();
                f.setType(fc2.getType());
                f.setProperties(newProps);
            }
            list.add(f);
        }
        for (FormControl lbl : labels) {
            int index = list.indexOf(lbl);
            if (index == list.size() - 1) {
                list.remove(lbl);
                continue;
            }
            FormControl fc3 = (FormControl)list.get(index + 1);
            if (!CATEGORY_LABEL.equals(fc3.getProperties().get("name"))) continue;
            list.remove(lbl);
        }
        if (!list.isEmpty() && CATEGORY_LABEL.equals((fc = (FormControl)list.get(0)).getProperties().get("name"))) {
            fc.getProperties().put("padding", new Insets(0, 0, 0, 0));
            fc.getProperties().put("preferredSize", new Dimension(0, 20));
        }
        return list;
    }

    public static Map buildModel(Map entity, List<Map> fields, List<String> includeFields) {
        for (Map field : fields) {
            if (includeFields.indexOf(field.get("name")) >= 0) {
                if (entity.containsKey(field.get("name"))) continue;
                if ("subform".equals(field.get("type"))) {
                    entity.put(field.get("name"), new HashMap());
                    continue;
                }
                entity.put(field.get("name"), null);
                continue;
            }
            if ("hidden".equals(field.get("mode")) || "fixed".equals(field.get("mode"))) continue;
            entity.remove(field.get("name"));
        }
        return entity;
    }

    public static Map getHtmlValueFormat(List<FormControl> controls, Object entity) {
        return FormControlUtil.getInstance().buildHtmlValueFormat(controls, entity);
    }

    public static Map getPrintValueFormat(List<FormControl> controls, Object entity) {
        return FormControlUtil.getInstance().buildPrintValueFormat(controls, entity);
    }

    public static Map filterMap(Map entity, List fields) {
        LinkedHashMap newMap = new LinkedHashMap();
        if (fields != null) {
            for (Object o : fields) {
                newMap.put(o, entity.get(o));
            }
        }
        return newMap;
    }

    public static void checkRequired(Map entity, List<Map> metaFields) {
        StringBuffer errs = new StringBuffer();
        for (Map.Entry me : entity.entrySet()) {
            if (me.getValue() != null) continue;
            final String key = (String)me.getKey();
            Map z = (Map)FormSupport.find(metaFields, new Filter<Map>(){

                @Override
                public boolean accept(Map o) {
                    return o.get("name").equals(key);
                }
            });
            errs.append(z.get("caption") + " is required\n");
        }
        if (errs.length() > 0) {
            throw new RuntimeException(errs.toString());
        }
    }

    private static Object find(List items, Filter filter) {
        for (Object o : items) {
            if (!filter.accept(o)) continue;
            return o;
        }
        return null;
    }

    private static interface Filter<T> {
        public boolean accept(T var1);
    }
}

