/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.impl;

import com.rameses.common.PropertyResolver;
import com.rameses.platform.interfaces.ContentPane;
import com.rameses.platform.interfaces.MainWindow;
import com.rameses.platform.interfaces.Notifier;
import com.rameses.platform.interfaces.Platform;
import com.rameses.platform.interfaces.SubWindow;
import com.rameses.rcp.impl.MainDialog;
import com.rameses.rcp.impl.NotifierImpl;
import com.rameses.rcp.impl.PlatformTabWindow;
import com.rameses.rcp.impl.PopupDialog;
import com.rameses.rcp.util.ErrorDialog;
import com.rameses.util.ValueUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class PlatformImpl
implements Platform {
    private MainDialog mainWindow;
    private NotifierImpl notifier;
    Map windows = new HashMap();

    public PlatformImpl() {
        this.mainWindow = new MainDialog(this);
    }

    @Override
    public void showStartupWindow(JComponent actionSource, JComponent comp, Map properties) {
        String id = (String)properties.get("id");
        if (ValueUtil.isEmpty((Object)id)) {
            throw new IllegalStateException("id is required for a page.");
        }
        if (this.windows.containsKey(id)) {
            return;
        }
        PlatformTabWindow tab = new PlatformTabWindow(id, comp, this, false);
        tab.setTitle((String)properties.get("title"));
        this.mainWindow.setComponent(tab, "content");
        this.windows.put(id, this.mainWindow);
    }

    @Override
    public void showWindow(JComponent actionSource, JComponent comp, Map properties) {
        String id = (String)properties.get("id");
        if (id == null || id.trim().length() == 0) {
            throw new IllegalStateException("id is required for a page.");
        }
        if (this.windows.containsKey(id)) {
            return;
        }
        String title = (String)properties.get("title");
        if (title == null || title.length() == 0) {
            properties.put("title", id);
            title = id;
        }
        comp.putClientProperty("Window.properties", properties);
        String windowmode = (String)properties.get("windowmode");
        if ("glasspane".equals(windowmode)) {
            this.showGlassPane(actionSource, comp, properties, id);
            return;
        }
        String canClose = (String)properties.get("canclose");
        String modal = properties.remove("modal") + "";
        PlatformTabWindow t = new PlatformTabWindow(id, comp, this);
        t.setTitle(title);
        t.setCanClose(!"false".equals(canClose));
        this.mainWindow.setComponent(t, "content");
        this.windows.put(id, t);
    }

    @Override
    public void showPopup(JComponent actionSource, JComponent comp, Map properties) {
        String id = (String)properties.get("id");
        if (id == null || id.trim().length() == 0) {
            throw new IllegalStateException("id is required for a page.");
        }
        if (this.windows.containsKey(id)) {
            return;
        }
        String title = (String)properties.get("title");
        if (title == null || title.length() == 0) {
            properties.put("title", id);
            title = id;
        }
        comp.putClientProperty("Window.properties", properties);
        String windowmode = (String)properties.get("windowmode");
        if ("glasspane".equals(windowmode)) {
            this.showGlassPane(actionSource, comp, properties, id);
            return;
        }
        String modal = properties.get("modal") + "";
        Window parent = this.getParentWindow(actionSource);
        PopupDialog dd = null;
        dd = parent instanceof JDialog ? new PopupDialog((JDialog)parent) : (parent instanceof JFrame ? new PopupDialog((JFrame)parent) : new PopupDialog());
        if (properties.size() > 0) {
            this.setProperties(dd, properties);
        }
        final PopupDialog d = dd;
        d.setTitle(title);
        d.setContentPane(comp);
        d.setId(id);
        d.setPlatformImpl(this);
        d.setModal(!"false".equals(modal));
        if ("false".equals(properties.get("resizable") + "")) {
            d.setResizable(false);
        }
        if ("true".equals(properties.get("undecorated") + "")) {
            d.setUndecorated(true);
        }
        if ("true".equals(properties.get("headless") + "")) {
            d.setUndecorated(true);
        }
        if ("true".equals(properties.get("alwaysOnTop") + "")) {
            d.setAlwaysOnTop(true);
            d.setModal(false);
        }
        d.pack();
        Dimension dim = d.getSize();
        int width = this.toInt(properties.get("width"));
        int height = this.toInt(properties.get("height"));
        int pWidth = width <= 0 ? dim.width : width;
        int pHeight = height <= 0 ? dim.height : height;
        d.setSize(pWidth, pHeight);
        d.setLocationRelativeTo(parent);
        d.setSource(actionSource);
        KeyStroke ks = KeyStroke.getKeyStroke("ctrl shift I");
        ShowInfoAction al = new ShowInfoAction(comp);
        JRootPane rootPane = d.getRootPane();
        rootPane.registerKeyboardAction(al, ks, 2);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                d.setVisible(true);
            }
        };
        this.windows.put(id, d);
        if ("true".equals(properties.get("immediate") + "")) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    private void showGlassPane(JComponent actionSource, JComponent comp, Map props, String id) {
        Container con = this.mainWindow.getGlassPane();
        con.removeAll();
        con.add(comp);
        con.setName(id);
        con.setVisible(true);
        this.windows.put(id, con);
    }

    private void showInfo(ActionEvent e) {
    }

    private void setProperties(Object bean, Map properties) {
        PropertyResolver resolver = PropertyResolver.getInstance();
        for (Map.Entry me : properties.entrySet()) {
            try {
                resolver.setProperty(bean, me.getKey().toString(), me.getValue());
            }
            catch (Exception exception) {}
        }
    }

    private int toInt(Object value) {
        if (value == null) {
            return -1;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (Exception ex) {
            return -1;
        }
    }

    @Override
    public void showError(JComponent actionSource, Exception e) {
        ErrorDialog.show(e, actionSource);
    }

    @Override
    public boolean showConfirm(JComponent actionSource, Object message) {
        return JOptionPane.showConfirmDialog(this.getParentWindow(actionSource), message, "Confirm", 0) == 0;
    }

    @Override
    public void showInfo(JComponent actionSource, Object message) {
        JOptionPane.showMessageDialog(this.getParentWindow(actionSource), message, "Information", 1);
    }

    @Override
    public void showAlert(JComponent actionSource, Object message) {
        JOptionPane.showMessageDialog(this.getParentWindow(actionSource), message, "Warning", 2);
    }

    @Override
    public Object showInput(JComponent actionSource, Object message) {
        return JOptionPane.showInputDialog(this.getParentWindow(actionSource), message);
    }

    @Override
    public MainWindow getMainWindow() {
        return this.mainWindow;
    }

    public Notifier getNotifier() {
        if (this.notifier == null) {
            this.notifier = new NotifierImpl();
        }
        return this.notifier;
    }

    @Override
    public boolean isWindowExists(String id) {
        return this.windows.containsKey(id);
    }

    @Override
    public void closeWindow(String id) {
        if (this.windows.containsKey(id)) {
            SubWindow d = (SubWindow)this.windows.get(id);
            d.closeWindow();
        }
    }

    @Override
    public void activateWindow(String id) {
        if (this.windows.containsKey(id)) {
            SubWindow w = (SubWindow)this.windows.get(id);
            if (w instanceof JDialog) {
                ((JDialog)((Object)w)).requestFocus();
            } else if (w instanceof PlatformTabWindow) {
                ((PlatformTabWindow)w).activate();
            }
        }
    }

    public Map getWindows() {
        return this.windows;
    }

    private Window getParentWindow(JComponent src) {
        if (src == null) {
            Window w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            if (w != null && w.isShowing()) {
                return w;
            }
            return this.mainWindow.getComponent();
        }
        return SwingUtilities.getWindowAncestor(src);
    }

    private String getMessage(Throwable t) {
        if (t == null) {
            return null;
        }
        String msg = t.getMessage();
        for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
            String s = cause.getMessage();
            if (s == null) continue;
            msg = s;
        }
        return msg;
    }

    @Override
    public void shutdown() {
        this.mainWindow.close();
    }

    @Override
    public void logoff() {
        this.mainWindow.close();
    }

    @Override
    public void lock() {
    }

    @Override
    public void unlock() {
    }

    @Override
    public void showFloatingWindow(JComponent owner, JComponent comp, Map properties) {
        this.showPopup(owner, comp, properties);
    }

    private class ShowInfoAction
    implements ActionListener {
        private Component source;

        ShowInfoAction(Component source) {
            this.source = source;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!(this.source instanceof ContentPane.View)) {
                return;
            }
            ((ContentPane.View)((Object)this.source)).showInfo();
        }
    }
}

