/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.framework;

import com.rameses.platform.interfaces.ContentPane;
import com.rameses.platform.interfaces.SubWindow;
import com.rameses.platform.interfaces.SubWindowListener;
import com.rameses.platform.interfaces.ViewContext;
import com.rameses.rcp.annotations.FormId;
import com.rameses.rcp.annotations.FormTitle;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.control.layout.CenterLayout;
import com.rameses.rcp.control.panel.DisabledPanel;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.framework.ContentLayer;
import com.rameses.rcp.framework.NavigatablePanel;
import com.rameses.rcp.framework.OpenerProvider;
import com.rameses.rcp.framework.UIController;
import com.rameses.rcp.framework.UIControllerContext;
import com.rameses.rcp.framework.UIViewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class UIControllerPanel
extends JPanel
implements NavigatablePanel,
ViewContext,
ContentPane.View,
ContentLayer {
    private boolean defaultBtnAdded;
    private InnerPanel contentPane;
    private Stack<UIControllerContext> controllers;
    private SubWindow parent;
    private String id;

    public UIControllerPanel() {
        this.initComponent();
    }

    public UIControllerPanel(UIControllerContext controller) {
        this.initComponent();
        this.controllers.push(controller);
        this._build(true);
    }

    private void initComponent() {
        this.controllers = new Stack();
        super.setLayout(new BorderLayout());
        this.setName("root");
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                if (UIControllerPanel.this.getDefaultButton() != null && !UIControllerPanel.this.defaultBtnAdded) {
                    UIControllerPanel.this.attachDefaultButton();
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }
        });
        this.contentPane = new InnerPanel();
        this.add(this.contentPane);
    }

    @Override
    public final void setLayout(LayoutManager mgr) {
    }

    @Override
    public Component add(Component comp) {
        if (comp instanceof InnerPanel) {
            return super.add(comp);
        }
        this.contentPane.add(comp);
        return comp;
    }

    @Override
    public void add(Component comp, Object constraints) {
        if (comp instanceof InnerPanel) {
            super.add(comp, constraints);
        } else {
            this.contentPane.add(comp, constraints);
        }
    }

    @Override
    public Component add(Component comp, int index) {
        if (comp instanceof InnerPanel) {
            return super.add(comp, index);
        }
        this.contentPane.add(comp, index);
        return comp;
    }

    @Override
    public Component add(String name, Component comp) {
        if (comp instanceof InnerPanel) {
            return super.add(name, comp);
        }
        this.contentPane.add(name, comp);
        return comp;
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        if (comp instanceof InnerPanel) {
            super.add(comp, constraints, index);
        }
        this.contentPane.add(comp, constraints, index);
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp instanceof InnerPanel) {
            this.removeAll();
            super.addImpl(comp, constraints, index);
        }
    }

    void attachDefaultButton() {
        JRootPane rp = this.getRootPane();
        JButton btn = this.getDefaultButton();
        if (btn != null && rp != null && rp.getDefaultButton() != btn) {
            rp.setDefaultButton(btn);
            this.defaultBtnAdded = true;
        } else {
            this.defaultBtnAdded = false;
        }
    }

    private JButton getDefaultButton() {
        UIControllerContext current = this.getCurrentController();
        if (current == null) {
            return null;
        }
        if (current.getCurrentView() == null) {
            return null;
        }
        return current.getCurrentView().getBinding().getDefaultButton();
    }

    private void _build(boolean allowViewRendering) {
        UIControllerContext current = this.getCurrentController();
        this.contentPane.removeAll();
        if (current == null) {
            SwingUtilities.updateComponentTreeUI(this);
            return;
        }
        if (!allowViewRendering) {
            return;
        }
        UIViewPanel view = current.getCurrentView();
        Binding binding = view.getBinding();
        binding.setViewContext(this);
        binding.setController(current.getController());
        Object viewname = view.getClientProperty("View.name");
        boolean activated = "true".equals(view.getClientProperty("UIViewPanel.activated") + "");
        if (!activated) {
            binding.fireActivatePage(viewname);
            view.putClientProperty("UIViewPanel.activated", "true");
        }
        this.contentPane.add(view);
        view.requestFocusInWindow();
        view.refresh();
        binding.focusFirstInput();
        binding.fireAfterRefresh(viewname);
        SwingUtilities.updateComponentTreeUI(this);
    }

    @Override
    public Stack<UIControllerContext> getControllers() {
        return this.controllers;
    }

    @Override
    public void setControllers(Stack<UIControllerContext> controllers) {
        this.controllers = controllers;
        this._build(true);
    }

    public UIControllerContext getCurrentController() {
        if (!this.controllers.empty()) {
            return this.controllers.peek();
        }
        return null;
    }

    @Override
    public void renderView() {
        Object flag = this.getClientProperty("navigatable-panel-render-view");
        boolean allowViewRendering = !(flag + "").matches("false");
        this._build(allowViewRendering);
    }

    @Override
    public boolean close() {
        try {
            return this.getCurrentController().getCurrentView().getBinding().close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    @Override
    public void display() {
        UIControllerContext current = this.getCurrentController();
        if (current != null) {
            UIViewPanel p = current.getCurrentView();
            p.getBinding().focusFirstInput();
        }
    }

    @Override
    public void setSubWindow(SubWindow subWindow) {
        this.parent = subWindow;
    }

    @Override
    public SubWindow getSubWindow() {
        return this.parent;
    }

    @Override
    public void activate() {
        try {
            this.getCurrentController().getCurrentView().getBinding().activate();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void buildFormAttrs(Map props) {
        Object bean;
        UIControllerContext uicc = this.getCurrentController();
        UIViewPanel uivp = uicc == null ? null : uicc.getCurrentView();
        Binding binding = uivp == null ? null : uivp.getBinding();
        Object object = bean = binding == null ? null : binding.getBean();
        if (bean == null) {
            return;
        }
        HashMap newmap = new HashMap();
        this.loadFormPropertiesFromAnnotation(newmap, bean, bean.getClass());
        props.putAll(newmap);
    }

    private void loadFormPropertiesFromAnnotation(Map props, Object bean, Class beanClass) {
        Object o;
        boolean accessible;
        for (Field field : beanClass.getDeclaredFields()) {
            accessible = field.isAccessible();
            try {
                if (field.isAnnotationPresent(FormId.class)) {
                    field.setAccessible(true);
                    o = props.get("id");
                    if (o == null || o.toString().trim().length() == 0) {
                        o = field.get(bean);
                    }
                    if (o != null && o.toString().trim().length() > 0) {
                        props.put("id", o);
                    }
                } else if (field.isAnnotationPresent(FormTitle.class)) {
                    field.setAccessible(true);
                    Object o2 = props.get("title");
                    if (o2 == null || o2.toString().trim().length() == 0) {
                        o2 = field.get(bean);
                    }
                    if (o2 != null && o2.toString().trim().length() > 0) {
                        props.put("title", o2);
                    }
                }
            }
            catch (Throwable o2) {
                // empty catch block
            }
            field.setAccessible(accessible);
        }
        for (AccessibleObject accessibleObject : beanClass.getDeclaredMethods()) {
            accessible = accessibleObject.isAccessible();
            try {
                if (accessibleObject.isAnnotationPresent(FormId.class)) {
                    ((Method)accessibleObject).setAccessible(true);
                    o = props.get("id");
                    if (o == null || o.toString().trim().length() == 0) {
                        o = ((Method)accessibleObject).invoke(bean, new Object[0]);
                    }
                    if (o != null && o.toString().trim().length() > 0) {
                        props.put("id", o);
                    }
                } else if (accessibleObject.isAnnotationPresent(FormTitle.class)) {
                    ((Method)accessibleObject).setAccessible(true);
                    o = props.get("title");
                    if (o == null || o.toString().trim().length() == 0) {
                        o = ((Method)accessibleObject).invoke(bean, new Object[0]);
                    }
                    if (o != null && o.toString().trim().length() > 0) {
                        props.put("title", o);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ((Method)accessibleObject).setAccessible(accessible);
        }
        Class superClass = beanClass.getSuperclass();
        if (superClass != null) {
            this.loadFormPropertiesFromAnnotation(props, bean, superClass);
        }
    }

    @Override
    public Map getInfo() {
        UIControllerContext current = this.getCurrentController();
        if (current == null) {
            return null;
        }
        UIController uic = current.getController();
        return uic == null ? null : uic.getInfo();
    }

    @Override
    public void showInfo() {
        Binding binding;
        UIControllerContext current = this.getCurrentController();
        if (current == null) {
            return;
        }
        Map info = this.getInfo();
        if (info == null || info.isEmpty()) {
            return;
        }
        OpenerProvider op = ClientContext.getCurrentContext().getOpenerProvider();
        if (op == null) {
            return;
        }
        HashMap<String, Map> params = new HashMap<String, Map>();
        params.put("info", info);
        Opener opener = null;
        try {
            opener = op.lookupOpener("workunit-info:show", params);
            opener.setTarget("popup");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (opener == null) {
            return;
        }
        UIViewPanel uiv = current.getCurrentView();
        Binding binding2 = binding = uiv == null ? null : uiv.getBinding();
        if (binding == null) {
            return;
        }
        binding.fireNavigation(opener);
    }

    @Override
    public void show(UIControllerPanel uic, Map props) {
        ModalView view = new ModalView(uic, props);
        uic.putClientProperty(SubWindow.class, view);
        this.contentPane.addView(view);
        this.contentPane.refresh();
    }

    private class ModalView
    extends JPanel
    implements SubWindow {
        UIControllerPanel root;
        private String id;
        private JInternalFrame frame;

        ModalView(Container con, Map props) {
            this.root = UIControllerPanel.this;
            this.setLayout(new CenterLayout());
            this.setOpaque(false);
            this.frame = new JInternalFrame("", false, false, false, false);
            this.frame.putClientProperty("JInternalFrame.isPalette", Boolean.TRUE);
            this.frame.setContentPane(con);
            this.frame.setFrameIcon(null);
            this.frame.setVisible(true);
            this.frame.pack();
            this.update(props);
            this.add(this.frame);
        }

        @Override
        public void update(Map props) {
            if (props == null) {
                return;
            }
            this.id = this.getString(props, "id");
            String title = this.getString(props, "title");
            if (title != null) {
                this.frame.setTitle(title);
            }
            Integer width = this.getInt(props, "width");
            Integer height = this.getInt(props, "height");
            Dimension dim = this.frame.getContentPane().getPreferredSize();
            if (width != null) {
                dim.width = width;
            }
            if (height != null) {
                dim.height = height;
            }
            this.frame.setPreferredSize(new Dimension(dim.width, dim.height));
        }

        String getString(Map props, Object key) {
            Object o = props == null ? null : (Object)props.get(key);
            return o == null ? null : o.toString();
        }

        Integer getInt(Map props, Object key) {
            String str = this.getString(props, key);
            try {
                return new Integer(str);
            }
            catch (Throwable t) {
                return null;
            }
        }

        ViewContext getViewContext() {
            if (this.frame.getContentPane() instanceof ViewContext) {
                return (ViewContext)((Object)this.frame.getContentPane());
            }
            return null;
        }

        @Override
        public String getName() {
            if (this.id == null) {
                return super.getName();
            }
            return this.id;
        }

        @Override
        public String getTitle() {
            return this.frame.getTitle();
        }

        @Override
        public void setTitle(String title) {
            this.frame.setTitle(title == null ? "" : title);
        }

        @Override
        public void closeWindow() {
            ViewContext vctx = this.getViewContext();
            if (vctx != null && vctx.close()) {
                this.frame.dispose();
                this.root.contentPane.remove(this);
                this.root.contentPane.refresh();
            }
        }

        @Override
        public void setListener(SubWindowListener listener) {
        }
    }

    private class InnerLayout
    implements LayoutManager {
        private InnerLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int w = margin.left + margin.right;
                int h = margin.top + margin.bottom;
                return new Dimension(w, h);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                Component[] comps = this.getVisibleComponents(parent);
                for (int i = 0; i < comps.length; ++i) {
                    Dimension dim = comps[i].getPreferredSize();
                    w = Math.max(w, dim.width);
                    h = Math.max(h, dim.height);
                }
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        private Component[] getVisibleComponents(Container parent) {
            ArrayList<Component> list = new ArrayList<Component>();
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!comps[i].isVisible()) continue;
                list.add(comps[i]);
            }
            return list.toArray(new Component[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                Component[] comps = this.getVisibleComponents(parent);
                for (int i = 0; i < comps.length; ++i) {
                    comps[i].setBounds(x, y, w, h);
                }
            }
        }
    }

    private class InnerPanel
    extends JLayeredPane {
        public InnerPanel() {
            super.setLayout(new InnerLayout());
        }

        @Override
        public final void setLayout(LayoutManager mgr) {
        }

        @Override
        public Component add(Component comp) {
            return comp;
        }

        void add(Container con) {
            if (con == null) {
                return;
            }
            this.removeAll();
            if (!(con instanceof DisabledPanel)) {
                con = new DisabledPanel(con);
            }
            super.add((Component)con, DEFAULT_LAYER);
        }

        void addView(ModalView view) {
            Component[] comps = this.getComponents();
            this.removeAll();
            super.add((Component)view, MODAL_LAYER);
            for (int i = 0; i < comps.length; ++i) {
                if (comps[i] instanceof ModalView) {
                    super.add(comps[i], MODAL_LAYER);
                    continue;
                }
                if (!(comps[i] instanceof DisabledPanel)) continue;
                ((DisabledPanel)comps[i]).setEnabled(false);
                super.add(comps[i], DEFAULT_LAYER);
            }
        }

        @Override
        public void remove(Component comp) {
            super.remove(comp);
            Component[] comps = this.getComponents();
            ModalView mv = this.findModalView(comps);
            if (mv == null) {
                Container con;
                for (int i = 0; i < comps.length; ++i) {
                    if (!(comps[i] instanceof DisabledPanel)) continue;
                    ((DisabledPanel)comps[i]).setEnabled(true);
                }
                DisabledPanel dp = this.findDisabledPanel(comps);
                if (dp != null && (con = dp.getSourceContainer()) != null) {
                    con.requestFocus();
                    con.requestFocusInWindow();
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                }
            }
        }

        void refresh() {
            UIControllerPanel.this.contentPane.revalidate();
            UIControllerPanel.this.contentPane.repaint();
        }

        ModalView findModalView(Component[] comps) {
            for (int i = 0; i < comps.length; ++i) {
                if (!(comps[i] instanceof ModalView)) continue;
                return (ModalView)comps[i];
            }
            return null;
        }

        DisabledPanel findDisabledPanel(Component[] comps) {
            for (int i = 0; i < comps.length; ++i) {
                if (!(comps[i] instanceof DisabledPanel)) continue;
                return (DisabledPanel)comps[i];
            }
            return null;
        }
    }
}

