/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.framework;

import com.rameses.rcp.common.CallbackHandlerProxy;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.framework.NotificationHandler;
import com.rameses.rcp.framework.NotificationProvider;
import java.util.HashMap;
import java.util.Map;

public final class RuntimeNotificationHandle {
    private Binding binding;
    private HandlerProxy proxy;

    RuntimeNotificationHandle(Binding binding) {
        this.binding = binding;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public NotificationProvider getProvider() {
        return ClientContext.getCurrentContext().getNotificationProvider();
    }

    public void publish(Object data) {
        this.getProvider().sendMessage(data);
    }

    public void markAsRead(Object data) {
        this.getProvider().removeMessage(data);
    }

    public void register(Object callback) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("onmessage", callback);
        this.register(options);
    }

    public void register(Map options) {
        if (options == null) {
            options = new HashMap();
        }
        this.proxy = new HandlerProxy(options);
        this.getProvider().add(this.proxy);
    }

    public void unregister() {
        if (this.proxy == null) {
            return;
        }
        this.proxy.cancelled = true;
        this.getProvider().remove(this.proxy);
        this.proxy.onClose();
        this.proxy = null;
    }

    private static class HandlerProxy
    implements NotificationHandler {
        private Map options;
        private CallbackHandlerProxy onmessageHandler;
        private CallbackHandlerProxy onreadHandler;
        private CallbackHandlerProxy oncloseHandler;
        private boolean cancelled;

        HandlerProxy(Map options) {
            this.options = options;
            Object source = this.get(options, "onmessage");
            if (source != null) {
                this.onmessageHandler = new CallbackHandlerProxy(source);
            }
            if ((source = this.get(options, "onread")) != null) {
                this.onreadHandler = new CallbackHandlerProxy(source);
            }
            if ((source = this.get(options, "onclose")) != null) {
                this.oncloseHandler = new CallbackHandlerProxy(source);
            }
        }

        @Override
        public void onMessage(Object data) {
            if (this.cancelled || this.onmessageHandler == null) {
                return;
            }
            this.onmessageHandler.call(data);
        }

        @Override
        public void onRead(Object data) {
            if (this.cancelled || this.onreadHandler == null) {
                return;
            }
            this.onreadHandler.call(data);
        }

        public void onClose() {
            if (this.cancelled || this.oncloseHandler == null) {
                return;
            }
            this.oncloseHandler.call();
        }

        private Integer getInt(Map map, String name) {
            try {
                return (Integer)map.get(name);
            }
            catch (Throwable t) {
                return null;
            }
        }

        private String getString(Map map, String name) {
            try {
                Object o = map.get(name);
                return o == null ? null : o.toString();
            }
            catch (Throwable t) {
                return null;
            }
        }

        private Boolean getBool(Map map, String name) {
            try {
                return (Boolean)map.get(name);
            }
            catch (Throwable t) {
                return null;
            }
        }

        private Object get(Map map, String name) {
            return map == null ? null : map.get(name);
        }
    }
}

