/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.framework;

import com.rameses.rcp.framework.EventListener;
import com.rameses.util.BreakException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class EventManager {
    private Map<String, List<EventListener>> listeners = new HashMap<String, List<EventListener>>();

    public void register(String name) {
        this.register(name, null);
    }

    public void register(String name, EventListener el) {
        String sname = name.toLowerCase();
        List<EventListener> list = this.listeners.get(sname);
        if (list == null) {
            list = new ArrayList<EventListener>();
            this.listeners.put(sname, list);
        }
        if (el != null) {
            list.add(el);
        }
    }

    public void unregister(String name) {
        List<EventListener> list = this.listeners.remove(name.toLowerCase());
        if (list == null) {
            return;
        }
        while (!list.isEmpty()) {
            EventListener el = list.remove(0);
            try {
                el.onUnregister();
            }
            catch (Throwable throwable) {}
        }
    }

    public void add(String name, EventListener el) {
        String sname = name.toLowerCase();
        List<EventListener> list = this.listeners.get(sname);
        if (list != null) {
            list.add(el);
        }
    }

    public void remove(String name) {
        List<EventListener> list = this.listeners.remove(name.toLowerCase());
        if (list != null) {
            list.clear();
        }
    }

    public void postEvent(String name, Object eventObject) {
        String sname = name.toLowerCase();
        List<EventListener> list = this.listeners.get(sname);
        if (list == null) {
            return;
        }
        for (EventListener el : list) {
            try {
                el.onEvent(eventObject);
            }
            catch (BreakException breakException) {}
        }
    }

    public void destroyEvents() {
        for (Map.Entry<String, List<EventListener>> me : this.listeners.entrySet()) {
            List<EventListener> list = me.getValue();
            if (list == null) continue;
            while (!list.isEmpty()) {
                EventListener el = list.remove(0);
                try {
                    el.onDestroy();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void sendMessage(String name, Object eventObject) {
        String sname = name.toLowerCase();
        List<EventListener> list = this.listeners.get(sname);
        if (list == null) {
            return;
        }
        for (EventListener el : list) {
            try {
                el.onMessage(eventObject);
            }
            catch (BreakException breakException) {}
        }
    }
}

